/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal.search.v1;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.npm.NpmSearchParameterExtractor;
import com.sonatype.nexus.repository.npm.internal.search.v1.NpmSearchResponse;
import com.sonatype.nexus.repository.npm.internal.search.v1.NpmSearchResponseFactory;
import com.sonatype.nexus.repository.npm.internal.search.v1.NpmSearchResponseMapper;
import com.sonatype.nexus.repository.npm.internal.search.v1.NpmSearchResponseObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.group.GroupFacet;
import org.sonatype.nexus.repository.group.GroupHandler;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Parameters;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.payloads.StringPayload;

@Named
@Singleton
public class NpmSearchGroupHandler
extends GroupHandler {
    private final NpmSearchParameterExtractor npmSearchParameterExtractor;
    private final NpmSearchResponseFactory npmSearchResponseFactory;
    private final NpmSearchResponseMapper npmSearchResponseMapper;
    private final int v1SearchMaxResults;

    @Inject
    public NpmSearchGroupHandler(NpmSearchParameterExtractor npmSearchParameterExtractor, NpmSearchResponseFactory npmSearchResponseFactory, NpmSearchResponseMapper npmSearchResponseMapper, @Named(value="${nexus.npm.v1SearchMaxResults:-250}") @Named(value="${nexus.npm.v1SearchMaxResults:-250}") int v1SearchMaxResults) {
        this.npmSearchParameterExtractor = (NpmSearchParameterExtractor)Preconditions.checkNotNull((Object)npmSearchParameterExtractor);
        this.npmSearchResponseFactory = (NpmSearchResponseFactory)((Object)Preconditions.checkNotNull((Object)((Object)npmSearchResponseFactory)));
        this.npmSearchResponseMapper = (NpmSearchResponseMapper)((Object)Preconditions.checkNotNull((Object)((Object)npmSearchResponseMapper)));
        this.v1SearchMaxResults = v1SearchMaxResults;
    }

    protected Response doGet(@Nonnull Context context, @Nonnull GroupHandler.DispatchedRepositories dispatched) throws Exception {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)dispatched);
        Request request = context.getRequest();
        Parameters parameters = request.getParameters();
        String text = this.npmSearchParameterExtractor.extractText(parameters);
        NpmSearchResponse response = text.isEmpty() ? this.npmSearchResponseFactory.buildEmptyResponse() : this.searchMembers(context, dispatched, parameters);
        String content = this.npmSearchResponseMapper.writeString(response);
        return HttpResponses.ok((Payload)new StringPayload(content, "application/json"));
    }

    private NpmSearchResponse searchMembers(Context context, GroupHandler.DispatchedRepositories dispatched, Parameters parameters) throws Exception {
        int from = this.npmSearchParameterExtractor.extractFrom(parameters);
        int size = this.npmSearchParameterExtractor.extractSize(parameters);
        parameters.replace("from", new String[]{"0"});
        parameters.replace("size", new String[]{Integer.toString(this.v1SearchMaxResults)});
        GroupFacet groupFacet = (GroupFacet)context.getRepository().facet(GroupFacet.class);
        Set<Map.Entry<Repository, Response>> entries = this.getAll(context, groupFacet.members(), dispatched).entrySet();
        List<NpmSearchResponseObject> mergedResponses = this.mergeAndNormalizeResponses(entries);
        mergedResponses.sort(Comparator.comparingDouble(NpmSearchResponseObject::getSearchScore).reversed());
        List<NpmSearchResponseObject> mergedResponseObjects = mergedResponses.stream().skip(from).limit(size).collect(Collectors.toList());
        return this.npmSearchResponseFactory.buildResponseForObjects(mergedResponseObjects);
    }

    private List<NpmSearchResponseObject> mergeAndNormalizeResponses(Set<Map.Entry<Repository, Response>> entries) {
        LinkedHashMap<String, NpmSearchResponseObject> results = new LinkedHashMap<String, NpmSearchResponseObject>();
        for (Map.Entry<Repository, Response> entry : entries) {
            List<NpmSearchResponseObject> searchResponseObjects;
            NpmSearchResponse searchResponse = this.parseSearchResponse(entry.getKey(), entry.getValue());
            if (searchResponse == null || (searchResponseObjects = searchResponse.getObjects()) == null) continue;
            Double highestScore = null;
            for (NpmSearchResponseObject searchResponseObject : searchResponseObjects) {
                if (!this.isValidResponseObject(searchResponseObject)) continue;
                if (highestScore == null) {
                    highestScore = searchResponseObject.getSearchScore();
                }
                searchResponseObject.setSearchScore(searchResponseObject.getSearchScore() / highestScore);
                results.putIfAbsent(searchResponseObject.getPackageEntry().getName(), searchResponseObject);
            }
        }
        return new ArrayList<NpmSearchResponseObject>(results.values());
    }

    private boolean isValidResponseObject(@Nullable NpmSearchResponseObject responseObject) {
        return responseObject != null && responseObject.getSearchScore() != null && responseObject.getPackageEntry() != null && responseObject.getPackageEntry().getName() != null;
    }

    @Nullable
    private NpmSearchResponse parseSearchResponse(Repository repository, Response response) {
        Payload payload = response.getPayload();
        if (response.getStatus().getCode() == 200 && payload != null) {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (InputStream in = payload.openInputStream();){
                    return this.npmSearchResponseMapper.readFromInputStream(in);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.warn("Unable to process search response for repository {}, skipping", (Object)repository.getName(), (Object)e);
                }
                this.log.warn("Unable to process search response for repository {}, cause: {}, skipping", (Object)repository.getName(), (Object)e.getMessage());
            }
        }
        return null;
    }
}

