/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal.search.v1;

import com.sonatype.nexus.repository.npm.internal.NpmJsonUtils;
import com.sonatype.nexus.repository.npm.internal.NpmResponses;
import com.sonatype.nexus.repository.npm.internal.search.v1.NpmSearchFacet;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Named;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.httpclient.HttpClientFacet;
import org.sonatype.nexus.repository.proxy.ProxyFacet;
import org.sonatype.nexus.repository.view.Parameters;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.payloads.BytesPayload;

@Named
public class NpmSearchFacetProxy
extends FacetSupport
implements NpmSearchFacet {
    private static final String REPOSITORY_SEARCH_ASSET = "-/v1/search";

    @Override
    public Response searchV1(@Nonnull Parameters parameters) {
        try {
            HttpResponse response = ((HttpClientFacet)this.getRepository().facet(HttpClientFacet.class)).getHttpClient().execute((HttpUriRequest)new HttpGet(this.getRemoteSearchUri(parameters)));
            if (response.getStatusLine().getStatusCode() == 200) {
                return NpmResponses.ok(NpmSearchFacetProxy.toPayload(response));
            }
            return NpmResponses.failureWithStatusPayload(502, this.extractError(response));
        }
        catch (Exception e) {
            this.warn("An error occurred performing npm v1 search for {}", e, this.getRepository().getName());
            return NpmResponses.failureWithStatusPayload(500, "An error occurred while contacting the remote server. See your administrator for details.");
        }
    }

    private URI getRemoteSearchUri(Parameters parameters) {
        URI remoteUrl = ((ProxyFacet)this.getRepository().facet(ProxyFacet.class)).getConfiguration().getRemoteURL();
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)remoteUrl.resolve(REPOSITORY_SEARCH_ASSET));
        parameters.entries().stream().collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toList()))).forEach((k, v) -> {
            UriBuilder uriBuilder2 = uriBuilder.queryParam(k, v.toArray());
        });
        return uriBuilder.build(new Object[0]);
    }

    private void warn(String message, Exception e, Object ... objects) {
        if (this.log.isDebugEnabled()) {
            this.log.warn(message, (Object)objects, (Object)e);
        } else {
            Object[] args = new Object[objects.length + 1];
            System.arraycopy(objects, 0, args, 0, objects.length);
            args[args.length - 1] = e.getMessage();
            this.log.warn(String.valueOf(message) + " cause {}", args);
        }
    }

    private String extractError(HttpResponse response) {
        Optional<String> errorMessage = Optional.empty();
        HttpEntity entity = response.getEntity();
        try {
            NestedAttributesMap jsonResponse = NpmJsonUtils.parse(() -> ((HttpEntity)entity).getContent());
            errorMessage = Optional.ofNullable((String)jsonResponse.get("error", String.class));
        }
        catch (Exception e) {
            this.log.debug("Unable to extract error response for v1 search on {}", (Object)this.getRepository().getName(), (Object)e);
        }
        EntityUtils.consumeQuietly((HttpEntity)entity);
        return errorMessage.orElseGet(() -> "An unexpected error response from the remote server: " + response.getStatusLine().getStatusCode());
    }

    private static Payload toPayload(HttpResponse response) throws UnsupportedOperationException, IOException {
        HttpEntity entity = response.getEntity();
        NestedAttributesMap searchResponse = NpmJsonUtils.parse(() -> ((HttpEntity)entity).getContent());
        return new BytesPayload(NpmJsonUtils.bytes(searchResponse), ContentType.APPLICATION_JSON.toString());
    }
}

