/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal.search.v1;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.npm.NpmSearchParameterExtractor;
import com.sonatype.nexus.repository.npm.internal.NpmResponses;
import com.sonatype.nexus.repository.npm.internal.search.v1.NpmSearchFacet;
import com.sonatype.nexus.repository.npm.internal.search.v1.NpmSearchResponse;
import com.sonatype.nexus.repository.npm.internal.search.v1.NpmSearchResponseFactory;
import com.sonatype.nexus.repository.npm.internal.search.v1.NpmSearchResponseMapper;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.search.AssetSearchResult;
import org.sonatype.nexus.repository.search.ComponentSearchResult;
import org.sonatype.nexus.repository.search.SearchRequest;
import org.sonatype.nexus.repository.search.SearchResponse;
import org.sonatype.nexus.repository.search.SearchService;
import org.sonatype.nexus.repository.search.SortDirection;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Parameters;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.payloads.StringPayload;

@Named
public class NpmSearchFacetHosted
extends FacetSupport
implements NpmSearchFacet {
    private final SearchService searchService;
    private final NpmSearchParameterExtractor npmSearchParameterExtractor;
    private final NpmSearchResponseFactory npmSearchResponseFactory;
    private final NpmSearchResponseMapper npmSearchResponseMapper;
    private final int v1SearchMaxResults;

    @Inject
    public NpmSearchFacetHosted(SearchService searchService, NpmSearchParameterExtractor npmSearchParameterExtractor, NpmSearchResponseFactory npmSearchResponseFactory, NpmSearchResponseMapper npmSearchResponseMapper, @Named(value="${nexus.npm.v1SearchMaxResults:-250}") @Named(value="${nexus.npm.v1SearchMaxResults:-250}") int v1SearchMaxResults) {
        this.searchService = (SearchService)Preconditions.checkNotNull((Object)searchService);
        this.npmSearchParameterExtractor = (NpmSearchParameterExtractor)Preconditions.checkNotNull((Object)npmSearchParameterExtractor);
        this.npmSearchResponseFactory = (NpmSearchResponseFactory)((Object)Preconditions.checkNotNull((Object)((Object)npmSearchResponseFactory)));
        this.npmSearchResponseMapper = (NpmSearchResponseMapper)((Object)Preconditions.checkNotNull((Object)((Object)npmSearchResponseMapper)));
        this.v1SearchMaxResults = v1SearchMaxResults;
    }

    @Override
    public Response searchV1(Parameters parameters) throws IOException {
        NpmSearchResponse response;
        String text = this.npmSearchParameterExtractor.extractText(parameters);
        int size = this.npmSearchParameterExtractor.extractSize(parameters);
        int from = this.npmSearchParameterExtractor.extractFrom(parameters);
        if (text.isEmpty()) {
            response = this.npmSearchResponseFactory.buildEmptyResponse();
        } else {
            SearchRequest request = SearchRequest.builder().repository(this.getRepository().getName()).disjunction().includeAssets().searchFilters(this.npmSearchParameterExtractor.getSearchFiltersFromTextParameter(text)).limit(Integer.valueOf(this.v1SearchMaxResults)).offset(Integer.valueOf(from)).sortField("name").sortDirection(SortDirection.ASC).build();
            LinkedHashMap<String, ComponentSearchResult> results = new LinkedHashMap<String, ComponentSearchResult>();
            SearchResponse searchResponse = this.searchService.search(request);
            for (ComponentSearchResult hit : searchResponse.getSearchResults()) {
                String key = String.valueOf(hit.getGroup()) + "/" + hit.getName();
                ComponentSearchResult other = (ComponentSearchResult)results.get(key);
                if (other != null && !NpmSearchFacetHosted.shouldReplace(other, hit)) continue;
                results.put(key, hit);
            }
            response = this.npmSearchResponseFactory.buildResponseForResults(results.values(), size, from);
        }
        String content = this.npmSearchResponseMapper.writeString(response);
        return NpmResponses.ok((Payload)new Content((Payload)new StringPayload(content, "application/json")));
    }

    private static boolean shouldReplace(ComponentSearchResult existing, ComponentSearchResult candidate) {
        Optional<String> existingNormalizedVersion = NpmSearchFacetHosted.normalizedVersion(existing);
        Optional<String> candidateNormalizedVersion = NpmSearchFacetHosted.normalizedVersion(candidate);
        if (existingNormalizedVersion.isPresent() && candidateNormalizedVersion.isPresent()) {
            return existingNormalizedVersion.get().compareTo(candidateNormalizedVersion.get()) < 0;
        }
        if (existingNormalizedVersion.isPresent()) {
            return false;
        }
        if (candidateNormalizedVersion.isPresent()) {
            return true;
        }
        return Optional.ofNullable(existing.getVersion()).map(existingVersion -> existingVersion.compareTo(candidate.getVersion())).map(result -> result < 0).orElse(true);
    }

    private static Optional<String> normalizedVersion(ComponentSearchResult result) {
        return result.getAssets().stream().findAny().map(AssetSearchResult::getAttributes).map(attr -> attr.get("npm")).filter(Map.class::isInstance).map(Map.class::cast).map(npmAttr -> npmAttr.get("search_normalized_version")).filter(Objects::nonNull).map(Object::toString);
    }
}

