/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal.search.table;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.search.sql.SearchCustomFieldContributor;
import org.sonatype.nexus.repository.search.sql.SearchRecord;

@Singleton
@Named(value="npm")
public class NpmSearchCustomFieldContributor
extends ComponentSupport
implements SearchCustomFieldContributor {
    public void populateSearchCustomFields(SearchRecord searchTableData, Asset asset) {
        this.log.debug("Populating search custom fields for npm {}", (Object)asset.path());
        asset.component().map(Component::namespace).ifPresent(arg_0 -> ((SearchRecord)searchTableData).addFormatFieldValue1(arg_0));
        Object formatAttributes = asset.attributes().get("npm");
        Map attributes = formatAttributes instanceof Map ? (Map)formatAttributes : Collections.emptyMap();
        Optional.ofNullable((String)attributes.get("author")).ifPresent(arg_0 -> ((SearchRecord)searchTableData).addFormatFieldValue2(arg_0));
        Optional.ofNullable((String)attributes.get("description")).ifPresent(arg_0 -> ((SearchRecord)searchTableData).addFormatFieldValue3(arg_0));
        Optional.ofNullable((String)attributes.get("keywords")).ifPresent(arg_0 -> ((SearchRecord)searchTableData).addFormatFieldValue4(arg_0));
        Optional.ofNullable((String)attributes.get("license")).ifPresent(arg_0 -> ((SearchRecord)searchTableData).addFormatFieldValue5(arg_0));
        Optional.ofNullable((String)attributes.get("tagged_is")).ifPresent(arg_0 -> ((SearchRecord)searchTableData).addFormatFieldValue6(arg_0));
        Optional.ofNullable((String)attributes.get("tagged_not")).ifPresent(arg_0 -> ((SearchRecord)searchTableData).addFormatFieldValue7(arg_0));
    }
}

