/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal.search.legacy;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.io.Closer;
import com.sonatype.nexus.repository.npm.internal.NpmJsonUtils;
import com.sonatype.nexus.repository.npm.internal.NpmMetadataUtils;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.PathPayload;

@Deprecated
public class NpmSearchIndexFilter {
    private NpmSearchIndexFilter() {
    }

    public static Content filterModifiedSince(Content fullIndex, @Nullable DateTime lastModified) throws IOException {
        if (lastModified == null) {
            return fullIndex;
        }
        return NpmSearchIndexFilter.filter(fullIndex, new PackageModifiedSince(lastModified));
    }

    static Content filter(Content fullIndex, Predicate<NestedAttributesMap> predicate) throws IOException {
        Preconditions.checkNotNull((Object)fullIndex);
        Preconditions.checkNotNull(predicate);
        Path path = Files.createTempFile("npm-searchIndex-filter", "json", new FileAttribute[0]);
        try (Closer closer = Closer.create();){
            try {
                NestedAttributesMap packageRoot;
                JsonParser jsonParser = NpmJsonUtils.mapper.getFactory().createParser((InputStream)closer.register((Closeable)fullIndex.openInputStream()));
                if (jsonParser.nextToken() == JsonToken.START_OBJECT && "_updated".equals(jsonParser.nextFieldName())) {
                    jsonParser.nextValue();
                }
                JsonGenerator generator = (JsonGenerator)closer.register((Closeable)NpmJsonUtils.mapper.getFactory().createGenerator((OutputStream)new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0]))));
                generator.writeStartObject();
                generator.writeNumberField("_updated", System.currentTimeMillis());
                while ((packageRoot = NpmSearchIndexFilter.getNext(jsonParser)) != null) {
                    if (!predicate.apply((Object)packageRoot)) continue;
                    generator.writeObjectField(packageRoot.getKey(), (Object)packageRoot.backing());
                }
                generator.writeEndObject();
                generator.flush();
            }
            catch (Throwable t) {
                throw closer.rethrow(t);
            }
        }
        return new Content((Payload)new PathPayload(path, "application/json"));
    }

    @Nullable
    private static NestedAttributesMap getNext(JsonParser origin) throws IOException {
        String packageName = origin.nextFieldName();
        if (packageName == null) {
            return null;
        }
        origin.nextToken();
        return new NestedAttributesMap(packageName, (Map)origin.readValueAs(NpmJsonUtils.rawMapJsonTypeRef));
    }

    public static class PackageModifiedSince
    implements Predicate<NestedAttributesMap> {
        private final DateTime since;

        public PackageModifiedSince(DateTime since) {
            this.since = (DateTime)Preconditions.checkNotNull((Object)since);
        }

        public boolean apply(NestedAttributesMap input) {
            DateTime lastModified = NpmMetadataUtils.lastModified(input);
            return lastModified == null || this.since.isBefore((ReadableInstant)lastModified);
        }
    }
}

