/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal.orient;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.npm.internal.NpmQuarantinedVersionFacetSupport;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Priority;
import javax.cache.Cache;
import javax.cache.configuration.Factory;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.CreatedExpiryPolicy;
import javax.cache.expiry.Duration;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.audit.AuditRecorder;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.cache.CacheHelper;
import org.sonatype.nexus.capability.CapabilityRegistry;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.storage.StorageFacet;

@FeatureFlag(name="nexus.orient.enabled")
@Named
@Priority(value=0x7FFFFFFF)
public class OrientNpmQuarantinedVersionFacet
extends NpmQuarantinedVersionFacetSupport {
    private final CacheHelper cacheHelper;
    private volatile Cache<String, List<String>> allowedVersionsCache;
    private ReentrantReadWriteLock allowedVersionsCacheLock = new ReentrantReadWriteLock();

    @Inject
    public OrientNpmQuarantinedVersionFacet(EventManager eventManager, CapabilityRegistry capabilityRegistry, CacheHelper cacheHelper, @Named(value="${nexus.npm.firewall.quarantined_versions_timeout_seconds:-10}") @Named(value="${nexus.npm.firewall.quarantined_versions_timeout_seconds:-10}") int quarantinedVersionsTimeoutInSeconds, AuditRecorder auditRecorder) {
        super(eventManager, capabilityRegistry, quarantinedVersionsTimeoutInSeconds, auditRecorder);
        this.cacheHelper = (CacheHelper)Preconditions.checkNotNull((Object)cacheHelper);
    }

    @VisibleForTesting
    protected void doInit(Configuration configuration) throws Exception {
        super.doInit(configuration);
    }

    @Override
    public Optional<Blob> getBlob(BlobRef blobRef) {
        return Optional.ofNullable(((StorageFacet)this.getRepository().facet(StorageFacet.class)).blobStore().get(blobRef.getBlobId()));
    }

    @Override
    protected Optional<List<String>> get(String packageId) {
        this.allowedVersionsCacheLock.readLock().lock();
        try {
            this.maybeCreateCache();
            Optional<List<String>> optional = Optional.ofNullable((List)this.allowedVersionsCache.get((Object)packageId));
            return optional;
        }
        finally {
            this.allowedVersionsCacheLock.readLock().unlock();
        }
    }

    @Override
    protected void put(String packageId, List<String> allowedVersions) {
        this.allowedVersionsCacheLock.writeLock().lock();
        try {
            this.maybeCreateCache();
            this.allowedVersionsCache.put((Object)packageId, allowedVersions);
        }
        finally {
            this.allowedVersionsCacheLock.writeLock().unlock();
        }
    }

    private void maybeCreateCache() {
        if (this.allowedVersionsCache == null) {
            this.log.debug("Creating {} cache for: {}", (Object)"NPM_FIREWALL_ALLOWED_VERSIONS", (Object)this.getRepository());
            Factory expiryPolicyFactory = CreatedExpiryPolicy.factoryOf((Duration)this.getCacheDuration());
            MutableConfiguration config = new MutableConfiguration().setStoreByValue(false).setExpiryPolicyFactory(expiryPolicyFactory).setManagementEnabled(true).setStatisticsEnabled(true);
            this.allowedVersionsCache = this.cacheHelper.maybeCreateCache(this.getCacheName(), config);
            this.log.debug("Created {} cache for: {}", (Object)this.allowedVersionsCache.getName(), (Object)this.getRepository());
        }
    }

    protected void destroyCache() {
        this.log.debug("Destroying {} cache for: {}", (Object)"NPM_FIREWALL_ALLOWED_VERSIONS", (Object)this.getRepository());
        this.cacheHelper.maybeDestroyCache(this.getCacheName());
        this.allowedVersionsCache = null;
        this.log.debug("Destroyed {} cache for: {}", (Object)"NPM_FIREWALL_ALLOWED_VERSIONS", (Object)this.getRepository());
    }
}

