/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal.orient;

import com.google.common.hash.HashCode;
import com.sonatype.nexus.repository.npm.internal.NpmAuditTarballFacet;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.vulnerability.exceptions.TarballLoadingException;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
@Priority(value=0x7FFFFFFF)
public class OrientNpmAuditTarballFacet
extends NpmAuditTarballFacet {
    @Inject
    public OrientNpmAuditTarballFacet(@Named(value="${nexus.npm.audit.maxConcurrentRequests:-10}") @Named(value="${nexus.npm.audit.maxConcurrentRequests:-10}") int maxConcurrentRequests) {
        super(maxConcurrentRequests);
    }

    @Override
    protected Optional<String> getComponentHashsumForProxyRepo(Repository repository, Context context) throws TarballLoadingException {
        try {
            UnitOfWork.begin((Supplier)((StorageFacet)repository.facet(StorageFacet.class)).txSupplier());
            Optional<String> optional = this.getComponentHashsum(repository, context);
            return optional;
        }
        catch (IOException e) {
            throw new TarballLoadingException(e.getMessage(), (Exception)e);
        }
        finally {
            UnitOfWork.end();
        }
    }

    @Override
    protected Optional<String> getHashsum(AttributesMap attributes) {
        Map hashMap = (Map)attributes.get("hashCodesMap", Content.T_CONTENT_HASH_CODES_MAP);
        if (hashMap != null) {
            HashCode hashCode = (HashCode)hashMap.get(HashAlgorithm.SHA1);
            return Optional.ofNullable(hashCode.toString());
        }
        return Optional.empty();
    }
}

