/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal.orient;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.sonatype.nexus.repository.npm.internal.NpmFieldMatcher;
import com.sonatype.nexus.repository.npm.internal.NpmStreamingObjectMapper;
import com.sonatype.nexus.repository.npm.internal.orient.NpmFacetUtils;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.storage.MissingAssetBlobException;
import org.sonatype.nexus.repository.view.payloads.StreamPayload;

public class NpmStreamPayload
extends StreamPayload {
    private static final Logger log = LoggerFactory.getLogger(NpmStreamPayload.class);
    private String revId;
    private String packageId;
    private List<NpmFieldMatcher> fieldMatchers;
    private StreamPayload.InputStreamFunction<MissingAssetBlobException> missingBlobInputStreamSupplier;

    public NpmStreamPayload(InputStreamSupplier supplier) {
        super(supplier, -1L, "application/json");
    }

    public NpmStreamPayload packageId(String packageId) {
        this.packageId = packageId;
        return this;
    }

    public NpmStreamPayload revId(String revId) {
        this.revId = revId;
        return this;
    }

    public NpmStreamPayload fieldMatchers(List<NpmFieldMatcher> fieldMatchers) {
        this.fieldMatchers = fieldMatchers;
        return this;
    }

    public NpmStreamPayload missingBlobInputStreamSupplier(StreamPayload.InputStreamFunction<MissingAssetBlobException> missingBlobInputStreamSupplier) {
        this.missingBlobInputStreamSupplier = missingBlobInputStreamSupplier;
        return this;
    }

    public InputStream openInputStream() throws IOException {
        try {
            return super.openInputStream();
        }
        catch (MissingAssetBlobException e) {
            if (Objects.nonNull(this.missingBlobInputStreamSupplier)) {
                return this.missingBlobInputStreamSupplier.apply((Object)e);
            }
            log.warn("Missing blob for asset {} and no handler set to recover, for package '{}' and rev '{}'", new Object[]{e.getAsset(), Objects.toString(this.packageId, "unknown"), Objects.toString(this.revId, "unknown"), log.isDebugEnabled() ? e : null});
            return NpmFacetUtils.errorInputStream("Missing blob and no handler set to recover.");
        }
    }

    public void copy(InputStream input, OutputStream output) throws IOException {
        new NpmStreamingObjectMapper(this.packageId, this.revId, Objects.nonNull(this.fieldMatchers) ? this.fieldMatchers : Collections.emptyList()).configure(SerializationFeature.FLUSH_AFTER_WRITE_VALUE, false).disable(new JsonGenerator.Feature[]{JsonGenerator.Feature.AUTO_CLOSE_TARGET}).readAndWrite(input, (OutputStream)new BufferedOutputStream(output));
    }

    public List<NpmFieldMatcher> getFieldMatchers() {
        return this.fieldMatchers;
    }
}

