/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal.orient;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.npm.internal.NpmPublishParser;
import com.sonatype.nexus.repository.npm.internal.NpmPublishRequest;
import com.sonatype.nexus.repository.npm.internal.orient.NpmFacetUtils;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.security.SecuritySystem;
import org.sonatype.nexus.security.user.User;
import org.sonatype.nexus.security.user.UserNotFoundException;

@Named
@Singleton
public class NpmRequestParser
extends ComponentSupport {
    private static final JsonFactory jsonFactory = new JsonFactory();
    private final SecuritySystem securitySystem;

    @Inject
    public NpmRequestParser(SecuritySystem securitySystem) {
        this.securitySystem = securitySystem;
    }

    public NpmPublishRequest parsePublish(Repository repository, Payload payload) throws IOException {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)payload);
        StorageFacet storageFacet = (StorageFacet)repository.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob(payload, NpmFacetUtils.HASH_ALGORITHMS);){
            return this.parseNpmPublish(storageFacet, tempBlob, StandardCharsets.UTF_8);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    @VisibleForTesting
    NpmPublishRequest parseNpmPublish(StorageFacet storageFacet, TempBlob tempBlob, Charset charset) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStreamReader reader = new InputStreamReader(tempBlob.get(), charset);){
            NpmPublishRequest npmPublishRequest;
            JsonParser jsonParser;
            Throwable throwable2;
            block19: {
                throwable2 = null;
                Object var8_11 = null;
                jsonParser = jsonFactory.createParser((Reader)reader);
                NpmPublishParser parser = this.npmPublishParserFor(jsonParser, storageFacet);
                npmPublishRequest = parser.parse(this.getUserId());
                if (jsonParser == null) break block19;
                jsonParser.close();
            }
            return npmPublishRequest;
            {
                catch (Throwable throwable3) {
                    try {
                        if (jsonParser != null) {
                            jsonParser.close();
                        }
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (throwable2 == null) {
                            throwable2 = throwable4;
                        } else if (throwable2 != throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        throw throwable2;
                    }
                }
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
    }

    @Nullable
    private String getUserId() {
        try {
            User currentUser = this.securitySystem.currentUser();
            return currentUser == null ? null : currentUser.getUserId();
        }
        catch (UserNotFoundException userNotFoundException) {
            this.log.debug("No user found, no name replacement will occur");
            return null;
        }
    }

    @VisibleForTesting
    NpmPublishParser npmPublishParserFor(JsonParser jsonParser, StorageFacet storageFacet) {
        return new NpmPublishParser(jsonParser, (arg_0, arg_1) -> ((StorageFacet)storageFacet).createTempBlob(arg_0, arg_1), NpmFacetUtils.HASH_ALGORITHMS);
    }
}

