/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal.orient;

import com.sonatype.nexus.repository.npm.internal.NpmMetadataUtils;
import com.sonatype.nexus.repository.npm.internal.NpmPackageId;
import com.sonatype.nexus.repository.npm.internal.orient.NpmFacetUtils;
import java.io.IOException;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.transaction.UnitOfWork;

public class NpmPackageRootMetadataUtils {
    private NpmPackageRootMetadataUtils() {
    }

    public static NestedAttributesMap createFullPackageMetadata(NestedAttributesMap packageJson, String repositoryName, String sha1sum, @Nullable Repository repository, BiFunction<String, String, String> function) {
        String packageRootLatestVersion = Objects.isNull(repository) ? "" : NpmPackageRootMetadataUtils.getPackageRootLatestVersion(packageJson, repository);
        return com.sonatype.nexus.repository.npm.internal.NpmPackageRootMetadataUtils.createFullPackageMetadata(packageJson, repositoryName, sha1sum, packageRootLatestVersion, function);
    }

    private static String getPackageRootLatestVersion(NestedAttributesMap packageJson, Repository repository) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        NpmPackageId packageId = NpmPackageId.parse((String)packageJson.get("name"));
        try {
            String latestVersion;
            NestedAttributesMap packageRoot = NpmPackageRootMetadataUtils.getPackageRoot(tx, repository, packageId);
            if (Objects.nonNull(packageRoot) && Objects.nonNull(latestVersion = NpmMetadataUtils.getLatestVersionFromPackageRoot(packageRoot))) {
                return latestVersion;
            }
        }
        catch (IOException iOException) {}
        return "";
    }

    @Nullable
    public static NestedAttributesMap getPackageRoot(StorageTx tx, Repository repository, NpmPackageId packageId) throws IOException {
        Bucket bucket = tx.findBucket(repository);
        Asset packageRootAsset = NpmFacetUtils.findPackageRootAsset(tx, bucket, packageId);
        if (packageRootAsset != null) {
            return NpmFacetUtils.loadPackageRoot(tx, packageRootAsset);
        }
        return null;
    }
}

