/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal.orient;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.npm.NpmCoordinateUtil;
import com.sonatype.nexus.repository.npm.internal.NpmAttributes;
import com.sonatype.nexus.repository.npm.internal.NpmFormatAttributesExtractor;
import com.sonatype.nexus.repository.npm.internal.NpmPackageId;
import com.sonatype.nexus.repository.npm.internal.NpmPackageParser;
import com.sonatype.nexus.repository.npm.internal.orient.NpmFacetUtils;
import com.sonatype.nexus.repository.npm.orient.NpmFacet;
import com.sonatype.nexus.repository.npm.orient.internal.search.legacy.NpmSearchIndexInvalidatedEvent;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.joda.time.DateTime;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class NpmFacetImpl
extends FacetSupport
implements NpmFacet {
    private final NpmPackageParser npmPackageParser;

    @Inject
    public NpmFacetImpl(NpmPackageParser npmPackageParser) {
        this.npmPackageParser = (NpmPackageParser)((Object)Preconditions.checkNotNull((Object)((Object)npmPackageParser)));
    }

    @Override
    @Nullable
    public Asset findRepositoryRootAsset() {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        return NpmFacetUtils.findRepositoryRootAsset(tx, tx.findBucket(this.getRepository()));
    }

    @Override
    @Nullable
    public Asset putRepositoryRoot(AssetBlob assetBlob, @Nullable AttributesMap contentAttributes) throws IOException {
        Bucket bucket;
        Repository repository = this.getRepository();
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = NpmFacetUtils.findRepositoryRootAsset(tx, bucket = tx.findBucket(repository));
        if (asset == null) {
            asset = (Asset)tx.createAsset(bucket, repository.getFormat()).name("-/all");
            this.getEventManager().post((Object)new NpmSearchIndexInvalidatedEvent(repository));
            this.saveAsset(tx, asset, assetBlob, NpmAttributes.AssetKind.REPOSITORY_ROOT, contentAttributes);
        }
        return asset;
    }

    @Override
    @Nullable
    public Asset findPackageRootAsset(String packageId) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        return NpmFacetUtils.findPackageRootAsset(tx, tx.findBucket(this.getRepository()), NpmPackageId.parse(packageId));
    }

    @Override
    @Nullable
    public Asset putPackageRoot(String packageId, AssetBlob assetBlob, @Nullable AttributesMap contentAttributes) throws IOException {
        Bucket bucket;
        Repository repository = this.getRepository();
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = NpmFacetUtils.findPackageRootAsset(tx, bucket = tx.findBucket(repository), NpmPackageId.parse(packageId));
        if (asset == null) {
            asset = (Asset)tx.createAsset(bucket, repository.getFormat()).name(packageId);
            this.saveAsset(tx, asset, assetBlob, NpmAttributes.AssetKind.PACKAGE_ROOT, contentAttributes);
        }
        return asset;
    }

    @Override
    @Nullable
    public Asset findTarballAsset(String packageId, String tarballName) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        return NpmFacetUtils.findTarballAsset(tx, tx.findBucket(this.getRepository()), NpmPackageId.parse(packageId), tarballName);
    }

    @Override
    @Nullable
    public Asset putTarball(String packageId, String tarballName, AssetBlob assetBlob, @Nullable AttributesMap contentAttributes) throws IOException {
        String version = NpmCoordinateUtil.extractVersion(tarballName);
        return this.putTarball(packageId, tarballName, assetBlob, contentAttributes, version);
    }

    @Override
    @Nullable
    public Asset putTarball(String packageId, String tarballName, AssetBlob assetBlob, @Nullable AttributesMap contentAttributes, String version) throws IOException {
        Component tarballComponent;
        NpmPackageId npmPackageId;
        Bucket bucket;
        Repository repository = this.getRepository();
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = NpmFacetUtils.findTarballAsset(tx, bucket = tx.findBucket(repository), npmPackageId = NpmPackageId.parse(packageId), tarballName);
        if (asset == null && (asset = tx.firstAsset(tarballComponent = NpmFacetUtils.getOrCreateTarballComponent(tx, repository, npmPackageId, version))) == null) {
            asset = (Asset)tx.createAsset(bucket, tarballComponent).name(NpmFacetUtils.tarballAssetName(npmPackageId, tarballName));
        }
        this.maybeExtractFormatAttributes(tx, packageId, asset, assetBlob);
        this.saveAsset(tx, asset, assetBlob, NpmAttributes.AssetKind.TARBALL, contentAttributes);
        return asset;
    }

    private void saveAsset(StorageTx tx, Asset asset, AssetBlob assetBlob, NpmAttributes.AssetKind kind, @Nullable AttributesMap contentAttributes) {
        asset.formatAttributes().set("asset_kind", (Object)kind.name());
        Optional blobCreated = assetBlob.getCreatedTime();
        boolean newAsset = asset.blobCreated() == null;
        tx.attachBlob(asset, assetBlob);
        Content.applyToAsset((Asset)asset, (AttributesMap)Content.maintainLastModified((Asset)asset, (AttributesMap)contentAttributes));
        if (newAsset) {
            blobCreated.ifPresent(arg_0 -> ((Asset)asset).blobCreated(arg_0));
        }
        blobCreated.ifPresent(arg_0 -> ((Asset)asset).blobUpdated(arg_0));
        Optional.ofNullable(contentAttributes).map(it -> (DateTime)it.get("blob_created", DateTime.class)).ifPresent(arg_0 -> ((Asset)asset).blobCreated(arg_0));
        Optional.ofNullable(contentAttributes).map(it -> (DateTime)it.get("blob_updated", DateTime.class)).ifPresent(arg_0 -> ((Asset)asset).blobUpdated(arg_0));
        tx.saveAsset(asset);
    }

    private void maybeExtractFormatAttributes(StorageTx tx, String packageId, Asset asset, AssetBlob assetBlob) {
        Blob blob = tx.requireBlob(assetBlob.getBlobRef());
        Map<String, Object> formatAttributes = this.npmPackageParser.parsePackageJson(() -> ((Blob)blob).getInputStream());
        if (formatAttributes.isEmpty()) {
            this.log.warn("No format attributes found in package.json for npm package ID {}, will not be searchable", (Object)packageId);
        } else {
            NpmFormatAttributesExtractor formatAttributesExtractor = new NpmFormatAttributesExtractor(formatAttributes);
            formatAttributesExtractor.copyFormatAttributes(asset.formatAttributes());
        }
    }
}

