/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal.orient;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.npm.internal.NpmPackageId;
import com.sonatype.nexus.repository.npm.internal.NpmPackageParser;
import com.sonatype.nexus.repository.npm.internal.NpmVersionComparator;
import com.sonatype.nexus.repository.npm.internal.orient.NpmPackageRootMetadataUtils;
import com.sonatype.nexus.repository.npm.internal.orient.OrientNpmHostedFacet;
import java.io.IOException;
import java.util.Map;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.ComponentDirector;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named(value="npm")
@Singleton
public class NpmComponentDirector
extends ComponentSupport
implements ComponentDirector {
    private NpmPackageParser npmPackageParser;

    @Inject
    public NpmComponentDirector(NpmPackageParser npmPackageParser) {
        this.npmPackageParser = npmPackageParser;
    }

    public boolean allowMoveTo(Repository destination) {
        return true;
    }

    public boolean allowMoveTo(Component component, Repository destination) {
        return true;
    }

    public boolean allowMoveFrom(Repository source) {
        return true;
    }

    public Component afterMove(Component component, Repository destination) {
        destination.optionalFacet(OrientNpmHostedFacet.class).ifPresent(npmHostedFacet -> {
            UnitOfWork.begin((Supplier)((StorageFacet)destination.facet(StorageFacet.class)).txSupplier());
            try {
                this.updatePackageRoot((OrientNpmHostedFacet)npmHostedFacet, component, destination);
            }
            finally {
                UnitOfWork.end();
            }
        });
        return component;
    }

    @Transactional
    protected void updatePackageRoot(OrientNpmHostedFacet npmHostedFacet, Component component, Repository destination) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        tx.browseAssets(component).forEach(asset -> {
            Blob blob = (Blob)Preconditions.checkNotNull((Object)tx.getBlob(asset.blobRef()));
            Map<String, Object> packageJson = this.npmPackageParser.parsePackageJson(() -> ((Blob)blob).getInputStream());
            NpmPackageId packageId = NpmPackageId.parse((String)packageJson.get("name"));
            try {
                NestedAttributesMap updatedMetadata = NpmPackageRootMetadataUtils.createFullPackageMetadata(new NestedAttributesMap("metadata", packageJson), destination.getName(), blob.getMetrics().getSha1Hash(), destination, NpmVersionComparator.extractNewestVersion);
                npmHostedFacet.putPackageRoot(packageId, null, updatedMetadata);
            }
            catch (IOException e) {
                this.log.error("Failed to update package root, packageId: {}", (Object)packageId, (Object)e);
            }
        });
    }
}

