/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal.httpclient;

import java.net.URI;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.protocol.HttpContext;

@Named(value="npm")
@Singleton
public class NpmRedirectStrategy
extends DefaultRedirectStrategy {
    private static final String AMAZON_CREDENTIAL_PARAM = "X-Amz-Credential";

    public HttpUriRequest getRedirect(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext httpContext) throws ProtocolException {
        URI locationURI;
        String query;
        boolean isRedirected = this.isRedirected(httpRequest, httpResponse, httpContext);
        if (isRedirected && (query = (locationURI = this.createLocationURI(httpResponse.getFirstHeader("Location").getValue())).getQuery()) != null && query.contains(AMAZON_CREDENTIAL_PARAM)) {
            httpRequest.removeHeaders("Authorization");
        }
        return super.getRedirect(httpRequest, httpResponse, httpContext);
    }
}

