/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal.audit.parser;

import com.google.gson.Gson;
import com.sonatype.nexus.repository.npm.internal.audit.parser.PackageLock;
import com.sonatype.nexus.repository.npm.internal.audit.parser.PackageLockNode;
import com.sonatype.nexus.repository.npm.internal.audit.parser.RootPackageLockNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PackageLockParser {
    public static final String ROOT = "root";
    private static final Gson gson = new Gson();

    private PackageLockParser() {
    }

    public static PackageLock parse(String jsonString) {
        RootPackageLockNode rootNode = (RootPackageLockNode)gson.fromJson(jsonString, RootPackageLockNode.class);
        return new PackageLock(PackageLockParser.getAllDependencies(ROOT, rootNode, null, new HashMap<String, List<PackageLockNode>>()));
    }

    private static Map<String, List<PackageLockNode>> getAllDependencies(String key, PackageLockNode packageLockNode, String parentNode, Map<String, List<PackageLockNode>> npmDependencies) {
        String packageName = key;
        String packageVersion = packageLockNode.getVersion();
        packageLockNode.setParentNodeName(parentNode);
        if (packageVersion.startsWith("npm:")) {
            Pattern pattern = Pattern.compile("npm:([^@]+)@([\\d.]+.*)");
            Matcher matcher = pattern.matcher(packageVersion);
            if (matcher.matches()) {
                packageName = matcher.group(1);
                packageVersion = matcher.group(2);
            }
            packageLockNode.setVersion(packageVersion);
        }
        npmDependencies.computeIfAbsent(packageName, k -> new ArrayList()).add(packageLockNode);
        if (packageLockNode.getDependencies() != null) {
            packageLockNode.getDependencies().forEach((dependencyKey, dependencyValue) -> {
                String parentKey = !ROOT.equals(key) ? key : null;
                PackageLockParser.getAllDependencies(dependencyKey, dependencyValue, parentKey, npmDependencies);
            });
        }
        return npmDependencies;
    }
}

