/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal.audit.parser;

import com.sonatype.nexus.repository.npm.internal.audit.parser.PackageLockNode;
import com.sonatype.nexus.repository.npm.internal.audit.parser.RootPackageLockNode;
import com.sonatype.nexus.repository.npm.internal.audit.report.Resolve;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonatype.nexus.repository.vulnerability.AuditComponent;

public class PackageLock {
    private final Map<String, List<PackageLockNode>> nodes;

    public PackageLock(Map<String, List<PackageLockNode>> nodes) {
        this.nodes = nodes;
    }

    public Set<AuditComponent> getComponents(String applicationId) {
        return this.nodes.entrySet().stream().filter(entry -> !"root".equals(entry.getKey())).flatMap(entry -> ((List)entry.getValue()).stream().map(dependency -> new AuditComponent(applicationId, "npm", (String)entry.getKey(), dependency.getVersion()))).collect(Collectors.toSet());
    }

    public List<PackageLockNode> getNodes(String name, String version) {
        return this.nodes.get(name).stream().filter(packageNode -> version.equals(packageNode.getVersion())).collect(Collectors.toList());
    }

    public RootPackageLockNode getRoot() {
        return (RootPackageLockNode)this.nodes.get("root").iterator().next();
    }

    public List<Resolve> createResolve(int id, String name, String version) {
        List packageLockNodes = this.nodes.get(name).stream().filter(packageNode -> version.equals(packageNode.getVersion())).collect(Collectors.toList());
        return packageLockNodes.stream().map(node -> this.createResolve(id, name, (PackageLockNode)node)).collect(Collectors.toList());
    }

    private Resolve createResolve(int id, String name, PackageLockNode node) {
        LinkedList<String> pathList = new LinkedList<String>();
        pathList.add(name);
        this.getPathToNode(node, pathList);
        String path = String.join((CharSequence)">", pathList);
        return new Resolve(id, pathList, path, node.isDev(), node.isOptional(), false);
    }

    private void getPathToNode(PackageLockNode node, LinkedList<String> path) {
        String parentNodeName = node.getParentNodeName();
        if (parentNodeName != null) {
            path.addFirst(parentNodeName);
            PackageLockNode parentNode = this.nodes.get(parentNodeName).stream().filter(packageLockNode -> packageLockNode.getDependencies() != null).filter(packageLockNode2 -> packageLockNode2.getDependencies().containsValue(node)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.valueOf(parentNodeName) + " wasn't found in parsed package-lock.json"));
            this.getPathToNode(parentNode, path);
        }
    }
}

