/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.payloads.StringPayload;
import org.sonatype.nexus.security.SecuritySystem;
import org.sonatype.nexus.security.user.User;

@Named
@Singleton
public class NpmWhoamiHandler
implements Handler {
    private final SecuritySystem securitySystem;
    private final ObjectMapper objectMapper;

    @Inject
    public NpmWhoamiHandler(SecuritySystem securitySystem, ObjectMapper objectMapper) {
        this.securitySystem = (SecuritySystem)Preconditions.checkNotNull((Object)securitySystem);
        this.objectMapper = (ObjectMapper)Preconditions.checkNotNull((Object)objectMapper);
    }

    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        User user = this.securitySystem.currentUser();
        Username username = new Username(user == null ? "anonymous" : user.getUserId());
        StringPayload payload = new StringPayload(this.objectMapper.writeValueAsString((Object)username), "application/json");
        return HttpResponses.ok((Payload)payload);
    }

    private static final class Username {
        private final String username;

        public Username(String username) {
            this.username = username;
        }

        public String getUsername() {
            return this.username;
        }
    }
}

