/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.firewall.QuarantinedVersionFacetSupport;
import com.sonatype.nexus.repository.content.npm.NpmContentFacet;
import com.sonatype.nexus.repository.npm.internal.MetadataVersionParser;
import com.sonatype.nexus.repository.npm.internal.NpmFieldFactory;
import com.sonatype.nexus.repository.npm.internal.NpmFieldMatcher;
import com.sonatype.nexus.repository.npm.internal.NpmPackageId;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.sonatype.nexus.audit.AuditData;
import org.sonatype.nexus.audit.AuditRecorder;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.capability.CapabilityRegistry;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.firewall.event.QuarantineComponentsRequestEvent;

@Facet.Exposed
public abstract class NpmQuarantinedVersionFacetSupport
extends QuarantinedVersionFacetSupport {
    public static final String REMOVE_QUARANTINED_KEY = "removeQuarantinedVersions";
    public static final String CACHE_NAME = "NPM_FIREWALL_ALLOWED_VERSIONS";
    private final EventManager eventManager;
    private final int quarantinedVersionsTimeoutInSeconds;
    private final AuditRecorder auditRecorder;

    public NpmQuarantinedVersionFacetSupport(EventManager eventManager, CapabilityRegistry capabilityRegistry, int quarantinedVersionsTimeoutInSeconds, AuditRecorder auditRecorder) {
        super(capabilityRegistry);
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
        Preconditions.checkArgument((quarantinedVersionsTimeoutInSeconds > 0 ? 1 : 0) != 0, (String)"nexus.npm.firewall.quarantined_versions_timeout must be > 0. Value was %s", (int)quarantinedVersionsTimeoutInSeconds);
        this.quarantinedVersionsTimeoutInSeconds = quarantinedVersionsTimeoutInSeconds;
        this.auditRecorder = auditRecorder;
    }

    @Guarded(by={"STARTED"})
    public void maybeAddExcludedVersionsFieldMatchers(List<NpmFieldMatcher> fieldMatchers, NpmPackageId packageId, BlobRef blobRef, Repository repository) {
        Boolean removeQuarantinedVersions = (Boolean)repository.getConfiguration().attributes("npm").get(REMOVE_QUARANTINED_KEY, Boolean.class);
        if (!Boolean.TRUE.equals(removeQuarantinedVersions) || !this.isFirewallEnabled()) {
            return;
        }
        if (blobRef != null) {
            try {
                this.removeQuarantinedComponents(packageId, fieldMatchers, this.getBlob(blobRef), repository);
            }
            catch (Exception e) {
                this.log.warn("Error removing quarantined versions from metadata: {}", (Object)e.getMessage(), (Object)(this.log.isDebugEnabled() ? e : null));
            }
        }
    }

    public abstract Optional<Blob> getBlob(BlobRef var1);

    protected abstract Optional<List<String>> get(String var1);

    protected abstract void put(String var1, List<String> var2);

    protected String getCacheName() {
        return String.valueOf(this.getRepository().getName()) + "-" + CACHE_NAME;
    }

    private void removeQuarantinedComponents(NpmPackageId packageId, List<NpmFieldMatcher> fieldMatchers, Optional<Blob> blob, Repository repository) throws IOException {
        if (blob.isPresent()) {
            Map<String, String> versionHashes = MetadataVersionParser.readVersionHashes(blob.get().getInputStream());
            List<QuarantineComponentsRequestEvent.FirewallComponent> components = this.buildFirewallComponents(versionHashes, packageId);
            ArrayList<String> versions = new ArrayList<String>(versionHashes.keySet());
            List<String> quarantinedVersions = this.getQuarantinedVersions(packageId, repository, versions, components);
            List<NpmFieldMatcher> excludeVersions = quarantinedVersions.stream().map(v -> NpmFieldFactory.removeObjectFieldMatcher(v, "/versions/" + v)).collect(Collectors.toList());
            this.maybeRewriteLatest(excludeVersions, quarantinedVersions, versions);
            fieldMatchers.addAll(excludeVersions);
            if (!quarantinedVersions.isEmpty()) {
                this.log.info("Filtering quarantined versions for packageId {} metadata:{}", (Object)packageId, quarantinedVersions);
                this.auditNpmQuarantinedVersions(packageId.id(), repository.getName(), quarantinedVersions);
            }
        }
    }

    private List<QuarantineComponentsRequestEvent.FirewallComponent> buildFirewallComponents(Map<String, String> versionHashes, NpmPackageId packageId) {
        return versionHashes.entrySet().stream().filter(versionHash -> versionHash.getKey() != null).map(versionHash -> new QuarantineComponentsRequestEvent.FirewallComponent((String)versionHash.getValue(), NpmContentFacet.tarballPath(packageId, (String)versionHash.getKey()), (String)versionHash.getKey())).collect(Collectors.toList());
    }

    private List<String> getQuarantinedVersions(NpmPackageId packageId, Repository repository, List<String> versions, List<QuarantineComponentsRequestEvent.FirewallComponent> components) {
        try {
            Optional<List<String>> cachedAllowedVersionsOpt = this.get(packageId.id());
            if (cachedAllowedVersionsOpt.isPresent()) {
                return versions.stream().filter(this.quarantined(cachedAllowedVersionsOpt.get())).collect(Collectors.toList());
            }
            QuarantineComponentsRequestEvent request = new QuarantineComponentsRequestEvent(repository, components);
            this.eventManager.post((Object)request);
            List quarantinedPaths = (List)request.getResult().get(this.quarantinedVersionsTimeoutInSeconds, TimeUnit.SECONDS);
            ArrayList<String> quarantinedVersions = new ArrayList<String>();
            ArrayList<String> allowedVersions = new ArrayList<String>();
            for (QuarantineComponentsRequestEvent.FirewallComponent component : components) {
                if (quarantinedPaths.contains(component.getPath())) {
                    quarantinedVersions.add(component.getVersion());
                    continue;
                }
                allowedVersions.add(component.getVersion());
            }
            this.put(packageId.id(), allowedVersions);
            return quarantinedVersions;
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            this.log.error("Error getting quarantined versions for packageId '{}' '{}'", (Object)packageId.id(), (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private void maybeRewriteLatest(List<NpmFieldMatcher> excludeVersions, List<String> quarantinedVersions, List<String> allVersions) {
        if (excludeVersions.size() > 0) {
            excludeVersions.add(NpmFieldFactory.rewriteLatest(quarantinedVersions, allVersions));
        }
    }

    private Predicate<String> quarantined(List<String> allowedVersions) {
        return version -> !allowedVersions.contains(version);
    }

    private void auditNpmQuarantinedVersions(String packageId, String repository, List<String> quarantinedVersions) {
        AuditData auditData = new AuditData();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("repository.name", repository);
        attributes.put("format", "NPM");
        attributes.put("package.id", packageId);
        attributes.put("vulnerable.versions.list", quarantinedVersions);
        auditData.setAttributes(attributes);
        auditData.setContext("Filtering quarantined versions");
        auditData.setDomain("Npm Quarantine");
        auditData.setTimestamp(new Date());
        this.auditRecorder.record(auditData);
    }
}

