/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal;

import com.google.common.base.Preconditions;
import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import com.sonatype.nexus.repository.npm.internal.NpmVersionComparator;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sonatype.nexus.common.app.VersionComparator;

public final class NpmPackageId
implements Comparable<NpmPackageId> {
    private static final VersionComparator comparator = NpmVersionComparator.versionComparator;
    private static final Escaper escaper = UrlEscapers.urlPathSegmentEscaper();
    private static final int CHAR_LIMIT_PACKAGE_IDENTIFIER = 214;
    private final String scope;
    private final String name;
    private final String id;

    public NpmPackageId(@Nullable String scope, String name) {
        this(scope, name, null);
    }

    public NpmPackageId(@Nullable String scope, String name, String version) {
        Map<String, String> npmPackageIdData = this.validateNpmPackageIdData(scope, name, version);
        this.id = npmPackageIdData.get("id");
        this.scope = npmPackageIdData.get("scope");
        this.name = npmPackageIdData.get("name");
    }

    @Nullable
    public String scope() {
        return this.scope;
    }

    @Nonnull
    public String name() {
        return this.name;
    }

    @Nonnull
    public String id() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NpmPackageId)) {
            return false;
        }
        NpmPackageId that = (NpmPackageId)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public int compareTo(NpmPackageId o) {
        return comparator.compare(this.id, o.id);
    }

    public String toString() {
        return this.id();
    }

    public static NpmPackageId parse(String string) {
        String scope = null;
        String name = (String)Preconditions.checkNotNull((Object)string);
        int slashIndex = name.indexOf(47);
        if (string.startsWith("@") && slashIndex > -1) {
            scope = name.substring(1, slashIndex);
            name = name.substring(slashIndex + 1, name.length());
        }
        return new NpmPackageId(scope, name);
    }

    private Map<String, String> validateNpmPackageIdData(@Nullable String scope, String name, String version) {
        HashMap<String, String> npmPackage = new HashMap<String, String>();
        Preconditions.checkArgument((name.length() > 0 ? 1 : 0) != 0, (Object)"Name cannot be empty string");
        Preconditions.checkArgument((boolean)name.equals(escaper.escape(name)), (String)"Non URL-safe name: %s", (Object)name);
        if (scope == null) {
            npmPackage.put("id", name);
        } else {
            Preconditions.checkArgument((scope.length() > 0 ? 1 : 0) != 0, (Object)"Scope cannot be empty string");
            Preconditions.checkArgument((boolean)scope.equals(escaper.escape(scope)), (String)"Non URL-safe scope: %s", (Object)scope);
            npmPackage.put("id", version != null ? String.format("@%s/%s@%s", scope, name, version) : String.format("@%s/%s", scope, name));
        }
        Preconditions.checkArgument((((String)npmPackage.get("id")).length() < 214 ? 1 : 0) != 0, (String)"Must be shorter than 214 characters: %s", (Object)this.id);
        Preconditions.checkArgument((!((String)npmPackage.get("id")).startsWith(".") && !((String)npmPackage.get("id")).startsWith("_") ? 1 : 0) != 0, (String)"Package id starts with '.' or '_': %s", npmPackage.get("id"));
        npmPackage.put("scope", scope);
        npmPackage.put("name", name);
        return npmPackage;
    }
}

