/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal;

import com.sonatype.nexus.repository.npm.internal.NpmHostedFacet;
import com.sonatype.nexus.repository.npm.internal.NpmPackageId;
import com.sonatype.nexus.repository.npm.internal.NpmPaths;
import com.sonatype.nexus.repository.npm.internal.NpmResponses;
import com.sonatype.nexus.repository.npm.internal.NpmTokenFacet;
import com.sonatype.nexus.repository.npm.internal.search.legacy.NpmSearchIndexFacet;
import com.sonatype.nexus.repository.npm.internal.search.v1.NpmSearchFacet;
import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.repository.IllegalOperationException;
import org.sonatype.nexus.repository.InvalidContentException;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.group.GroupWriteDenyException;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Parameters;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;

public final class NpmHandlers {
    private static final Logger log = LoggerFactory.getLogger(NpmHandlers.class);
    public static Handler npmErrorHandler = new Handler(){

        @Nonnull
        public Response handle(@Nonnull Context context) throws Exception {
            try {
                return context.proceed();
            }
            catch (GroupWriteDenyException e) {
                Response error = NpmResponses.forbidden(e.getMessage());
                log.warn("Error: {} {}: {} - {}", new Object[]{context.getRequest().getAction(), context.getRequest().getPath(), error.getStatus(), e.getMessage(), e});
                return error;
            }
            catch (IllegalArgumentException | IllegalOperationException e) {
                Response error = NpmResponses.badRequest(e.getMessage());
                log.warn("Error: {} {}: {} - {}", new Object[]{context.getRequest().getAction(), context.getRequest().getPath(), error.getStatus(), e.getMessage(), e});
                return error;
            }
            catch (InvalidContentException e) {
                Response error = "PUT".equals(context.getRequest().getAction()) ? NpmResponses.badRequest(e.getMessage()) : NpmResponses.notFound(e.getMessage());
                log.warn("Error: {} {}: {} - {}", new Object[]{context.getRequest().getAction(), context.getRequest().getPath(), error.getStatus(), e.getMessage(), e});
                return error;
            }
        }
    };
    public static Handler getPackage = new Handler(){

        @Nonnull
        public Response handle(@Nonnull Context context) throws Exception {
            TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
            Repository repository = context.getRepository();
            log.debug("[getPackage] repository: {} tokens: {}", (Object)repository.getName(), (Object)state.getTokens());
            NpmPackageId packageId = NpmPaths.packageId(state);
            return ((NpmHostedFacet)repository.facet(NpmHostedFacet.class)).getPackage(packageId).map(NpmResponses::ok).orElseGet(() -> NpmResponses.packageNotFound(packageId));
        }
    };
    public static Handler putPackage = new Handler(){

        @Nonnull
        public Response handle(@Nonnull Context context) throws Exception {
            TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
            Repository repository = context.getRepository();
            log.debug("[putPackage] repository: {} tokens: {}", (Object)repository.getName(), (Object)state.getTokens());
            ((NpmHostedFacet)repository.facet(NpmHostedFacet.class)).putPackage(NpmPaths.packageId(state), NpmPaths.revision(state), context.getRequest().getPayload());
            return NpmResponses.ok();
        }
    };
    public static Handler deletePackage = new Handler(){

        @Nonnull
        public Response handle(@Nonnull Context context) throws Exception {
            TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
            Repository repository = context.getRepository();
            log.debug("[deletePackage] repository: {} tokens: {}", (Object)repository.getName(), (Object)state.getTokens());
            NpmPackageId packageId = NpmPaths.packageId(state);
            Set<String> deleted = ((NpmHostedFacet)repository.facet(NpmHostedFacet.class)).deletePackage(packageId, NpmPaths.revision(state));
            if (!deleted.isEmpty()) {
                return NpmResponses.ok();
            }
            return NpmResponses.packageNotFound(packageId);
        }
    };
    public static Handler getTarball = new Handler(){

        @Nonnull
        public Response handle(@Nonnull Context context) throws Exception {
            TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
            Repository repository = context.getRepository();
            log.debug("[getTarball] repository: {} tokens: {}", (Object)repository.getName(), (Object)state.getTokens());
            NpmPackageId packageId = NpmPaths.packageId(state);
            String tarballName = NpmPaths.tarballName(state);
            return ((NpmHostedFacet)repository.facet(NpmHostedFacet.class)).getTarball(packageId, tarballName).map(NpmResponses::ok).orElseGet(() -> NpmResponses.packageNotFound(packageId));
        }
    };
    public static Handler deleteTarball = new Handler(){

        @Nonnull
        public Response handle(@Nonnull Context context) throws Exception {
            TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
            Repository repository = context.getRepository();
            log.debug("[deleteTarball] repository: {} tokens: {}", (Object)repository.getName(), (Object)state.getTokens());
            NpmPackageId packageId = NpmPaths.packageId(state);
            String tarballName = NpmPaths.tarballName(state);
            NpmHostedFacet hostedFacet = (NpmHostedFacet)repository.facet(NpmHostedFacet.class);
            Optional<String> deleted = hostedFacet.deleteTarball(packageId, tarballName);
            if (!deleted.isPresent()) {
                return NpmResponses.tarballNotFound(packageId, tarballName);
            }
            hostedFacet.recalculateLatestBySemanticVersion(packageId);
            return NpmResponses.ok();
        }
    };
    @Deprecated
    public static Handler searchIndex = new Handler(){

        @Nonnull
        public Response handle(@Nonnull Context context) throws Exception {
            Repository repository = context.getRepository();
            Parameters parameters = context.getRequest().getParameters();
            log.debug("[searchIndex] repository: {} parameters: {}", (Object)repository.getName(), (Object)parameters);
            return NpmResponses.ok((Payload)((NpmSearchIndexFacet)repository.facet(NpmSearchIndexFacet.class)).searchIndex(NpmPaths.indexSince(parameters)));
        }
    };
    public static Handler searchV1 = new Handler(){

        @Nonnull
        public Response handle(@Nonnull Context context) throws Exception {
            Repository repository = context.getRepository();
            Parameters parameters = context.getRequest().getParameters();
            log.debug("[searchV1] repository: {} parameters: {}", (Object)repository.getName(), (Object)parameters);
            return ((NpmSearchFacet)repository.facet(NpmSearchFacet.class)).searchV1(parameters);
        }
    };
    public static Handler createToken = new Handler(){

        @Nonnull
        public Response handle(@Nonnull Context context) throws Exception {
            TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
            Repository repository = context.getRepository();
            log.debug("[createToken] repository: {} tokens: {}", (Object)repository.getName(), (Object)state.getTokens());
            return ((NpmTokenFacet)repository.facet(NpmTokenFacet.class)).login(context);
        }
    };
    public static Handler deleteToken = new Handler(){

        @Nonnull
        public Response handle(@Nonnull Context context) throws Exception {
            TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
            Repository repository = context.getRepository();
            log.debug("[deleteToken] repository: {} tokens: {}", (Object)repository.getName(), (Object)state.getTokens());
            return ((NpmTokenFacet)repository.facet(NpmTokenFacet.class)).logout(context);
        }
    };
    public static Handler getDistTags = new Handler(){

        @Nonnull
        public Response handle(@Nonnull Context context) throws Exception {
            TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
            Repository repository = context.getRepository();
            log.debug("[getPackage] repository: {} tokens: {}", (Object)repository.getName(), (Object)state.getTokens());
            NpmPackageId packageId = NpmPaths.packageId(state);
            return ((NpmHostedFacet)repository.facet(NpmHostedFacet.class)).getDistTags(packageId).map(NpmResponses::ok).orElseGet(() -> NpmResponses.packageNotFound(packageId));
        }
    };
    public static Handler putDistTags = new Handler(){

        @Nonnull
        public Response handle(@Nonnull Context context) throws Exception {
            TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
            Repository repository = context.getRepository();
            log.debug("[putDistTags] repository: {} tokens: {}", (Object)repository.getName(), (Object)state.getTokens());
            try {
                ((NpmHostedFacet)repository.facet(NpmHostedFacet.class)).putDistTags(NpmPaths.packageId(state), (String)state.getTokens().get("packageTag"), context.getRequest().getPayload());
                return NpmResponses.ok();
            }
            catch (IOException e) {
                return NpmResponses.badRequest(e.getMessage());
            }
        }
    };
    public static Handler deleteDistTags = new Handler(){

        @Nonnull
        public Response handle(@Nonnull Context context) throws Exception {
            TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
            Repository repository = context.getRepository();
            log.debug("[putDistTags] repository: {} tokens: {}", (Object)repository.getName(), (Object)state.getTokens());
            try {
                ((NpmHostedFacet)repository.facet(NpmHostedFacet.class)).deleteDistTags(NpmPaths.packageId(state), (String)state.getTokens().get("packageTag"), context.getRequest().getPayload());
                return NpmResponses.ok();
            }
            catch (IOException e) {
                return NpmResponses.badRequest(e.getMessage());
            }
        }
    };

    private NpmHandlers() {
    }
}

