/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.npm.internal.NpmFieldDeserializer;
import java.io.IOException;
import java.util.Objects;
import java.util.regex.Pattern;
import org.sonatype.nexus.repository.json.CurrentPathJsonParser;

public class NpmFieldMatcher {
    private final String fieldName;
    private final Pattern pattern;
    private final NpmFieldDeserializer deserializer;

    public NpmFieldMatcher(String fieldName, String pathRegex, NpmFieldDeserializer deserializer) {
        this.fieldName = (String)Preconditions.checkNotNull((Object)fieldName);
        this.pattern = Pattern.compile((String)Preconditions.checkNotNull((Object)pathRegex));
        this.deserializer = (NpmFieldDeserializer)Preconditions.checkNotNull((Object)deserializer);
    }

    public boolean allowDeserializationOnMatched() {
        return true;
    }

    public boolean matches(JsonParser parser) throws IOException {
        String currentName = parser.getCurrentName();
        return Objects.nonNull(currentName) && this.matchesFieldName(currentName) && this.matchesPath(parser);
    }

    private boolean matchesFieldName(String fieldName) {
        return this.fieldName.endsWith(fieldName);
    }

    private boolean matchesPath(JsonParser parser) {
        if (parser instanceof CurrentPathJsonParser) {
            return this.matchesPath(((CurrentPathJsonParser)parser).currentPath());
        }
        return false;
    }

    private boolean matchesPath(String path) {
        return this.pattern.matcher(path).matches();
    }

    public NpmFieldDeserializer getDeserializer() {
        return this.deserializer;
    }

    public String getFieldName() {
        return this.fieldName;
    }
}

