/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.mime.MimeRulesSource;
import org.sonatype.nexus.repository.mime.ContentValidator;
import org.sonatype.nexus.repository.mime.DefaultContentValidator;

@Named(value="npm")
@Singleton
public class NpmContentValidator
extends ComponentSupport
implements ContentValidator {
    private static final List<String> NPM_METADATA_TYPES = ImmutableList.of((Object)"application/json", (Object)"text/plain");
    private static final Set<String> NPM_TRUSTED_TYPES = ImmutableSet.of((Object)"text/html", (Object)"application/json", (Object)"application/gzip", (Object)"application/octet-stream");
    private final DefaultContentValidator defaultContentValidator;

    @Inject
    public NpmContentValidator(DefaultContentValidator defaultContentValidator) {
        this.defaultContentValidator = (DefaultContentValidator)Preconditions.checkNotNull((Object)defaultContentValidator);
    }

    @Nonnull
    public String determineContentType(boolean strictContentTypeValidation, InputStreamSupplier contentSupplier, @Nullable MimeRulesSource mimeRulesSource, @Nullable String contentName, @Nullable String declaredContentType) throws IOException {
        if (declaredContentType != null && NPM_TRUSTED_TYPES.contains(declaredContentType)) {
            return declaredContentType;
        }
        String name = this.restoreFileExtension(contentName, declaredContentType);
        return this.defaultContentValidator.determineContentType(strictContentTypeValidation, contentSupplier, mimeRulesSource, name, declaredContentType);
    }

    @Nullable
    private String restoreFileExtension(String name, String declaredContentType) {
        if (name == null) {
            return null;
        }
        if (!name.endsWith(".json") && NPM_METADATA_TYPES.contains(declaredContentType)) {
            return String.valueOf(name) + ".json";
        }
        if (!name.endsWith(".tgz")) {
            return String.valueOf(name) + ".tgz";
        }
        return name;
    }
}

