/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.npm.internal.NpmMetadataUtils;
import com.sonatype.nexus.repository.npm.internal.NpmPaths;
import com.sonatype.nexus.repository.npm.internal.NpmProxyFacet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.group.GroupHandler;
import org.sonatype.nexus.repository.proxy.ProxyFacet;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Matcher;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.vulnerability.AuditComponent;
import org.sonatype.nexus.repository.vulnerability.AuditRepositoryComponent;
import org.sonatype.nexus.repository.vulnerability.exceptions.TarballLoadingException;
import org.sonatype.nexus.thread.NexusExecutorService;
import org.sonatype.nexus.thread.NexusThreadFactory;

@Facet.Exposed
public abstract class NpmAuditTarballFacet
extends FacetSupport {
    private final int maxConcurrentRequests;
    private final TarballGroupHandler tarballGroupHandler;
    private ExecutorService executor;

    public NpmAuditTarballFacet(int maxConcurrentRequests) {
        Preconditions.checkArgument((maxConcurrentRequests > 0 ? 1 : 0) != 0, (Object)"nexus.npm.audit.maxConcurrentRequests must be greater than 0");
        this.maxConcurrentRequests = maxConcurrentRequests;
        this.tarballGroupHandler = new TarballGroupHandler(this::getHashsum);
    }

    protected void doStart() {
        this.executor = NexusExecutorService.forCurrentSubject((ExecutorService)Executors.newFixedThreadPool(this.maxConcurrentRequests, (ThreadFactory)new NexusThreadFactory("npm-audit-tasks", "npm-audit")));
    }

    protected void doStop() throws InterruptedException {
        this.executor.shutdown();
        if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
            this.log.warn("Failed to terminate thread pool in allotted time");
        }
        this.executor = null;
    }

    public Set<AuditRepositoryComponent> download(Context originalContext, Set<AuditComponent> auditComponents) throws TarballLoadingException {
        ArrayList tasks = new ArrayList();
        auditComponents.forEach(auditComponent -> {
            boolean bl = tasks.add(() -> this.download(originalContext, (AuditComponent)auditComponent));
        });
        List repositoryComponentFutures = tasks.stream().map(this.executor::submit).collect(Collectors.toList());
        HashSet<AuditRepositoryComponent> repositoryComponents = new HashSet<AuditRepositoryComponent>(auditComponents.size());
        try {
            for (Future repositoryComponentFuture : repositoryComponentFutures) {
                repositoryComponents.add((AuditRepositoryComponent)repositoryComponentFuture.get());
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        return repositoryComponents;
    }

    private AuditRepositoryComponent download(Context originalContext, AuditComponent auditComponent) throws TarballLoadingException {
        Optional<String> hashsumOpt;
        Preconditions.checkNotNull((Object)auditComponent);
        String packageName = auditComponent.getName();
        String packageVersion = auditComponent.getVersion();
        String repositoryPath = NpmMetadataUtils.createRepositoryPath(packageName, packageVersion);
        Request request = new Request.Builder().action("GET").path("/" + repositoryPath).build();
        Repository repository = this.getRepository();
        Context context = new Context(repository, request);
        context.getAttributes().backing().putAll(originalContext.getAttributes().backing());
        Matcher tarballMatcher = NpmPaths.tarballMatcher("GET").handler((Handler)new EmptyHandler()).create().getMatcher();
        tarballMatcher.matches(context);
        context.getAttributes().set(NpmProxyFacet.ProxyTarget.class, (Object)NpmProxyFacet.ProxyTarget.TARBALL);
        context.getAttributes().set("IGNORE_FIREWALL", (Object)true);
        String repositoryType = repository.getType().getValue();
        if (repositoryType.equals("group")) {
            hashsumOpt = this.tarballGroupHandler.getTarballHashsum(context);
        } else if (repositoryType.equals("proxy")) {
            hashsumOpt = this.getComponentHashsumForProxyRepo(repository, context);
        } else {
            String errorMsg = String.format("The %s repository is not supported", repositoryType);
            throw new UnsupportedOperationException(errorMsg);
        }
        if (!hashsumOpt.isPresent()) {
            this.log.warn(String.format("Can't get hashsum for the %s package", auditComponent));
            return new AuditRepositoryComponent(auditComponent.getPackageType(), repositoryPath, null);
        }
        return new AuditRepositoryComponent(auditComponent.getPackageType(), repositoryPath, hashsumOpt.get());
    }

    protected abstract Optional<String> getComponentHashsumForProxyRepo(Repository var1, Context var2) throws TarballLoadingException;

    protected Optional<String> getComponentHashsum(Repository repository, Context context) throws IOException {
        Content content = ((ProxyFacet)repository.facet(ProxyFacet.class)).get(context);
        if (content != null) {
            return this.getHashsum(content.getAttributes());
        }
        return Optional.empty();
    }

    protected abstract Optional<String> getHashsum(AttributesMap var1);

    private static final class EmptyHandler
    implements Handler {
        private EmptyHandler() {
        }

        @Nonnull
        public Response handle(@Nonnull Context context) throws Exception {
            return context.proceed();
        }
    }

    private static final class TarballGroupHandler
    extends GroupHandler {
        private final Function<AttributesMap, Optional<String>> hashFetcher;

        public TarballGroupHandler(Function<AttributesMap, Optional<String>> hashFetcher) {
            this.hashFetcher = hashFetcher;
        }

        public Optional<String> getTarballHashsum(Context context) throws TarballLoadingException {
            GroupHandler.DispatchedRepositories dispatched = (GroupHandler.DispatchedRepositories)context.getRequest().getAttributes().getOrCreate(GroupHandler.DispatchedRepositories.class);
            try {
                Response response = super.doGet(context, dispatched);
                if (response.getPayload() instanceof Content) {
                    Content content = (Content)response.getPayload();
                    return this.hashFetcher.apply(content.getAttributes());
                }
            }
            catch (Exception e) {
                throw new TarballLoadingException(e.getMessage(), e);
            }
            return Optional.empty();
        }
    }
}

