/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.datastore;

import com.sonatype.nexus.repository.npm.internal.NpmAttributes;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.export.ExportAssetFilter;

@Singleton
@Named(value="npm")
public class NpmExportAssetFilter
extends ComponentSupport
implements ExportAssetFilter {
    public boolean shouldSkipAsset(FluentAsset asset) {
        this.logFiltering(asset);
        return asset.kind().equals(NpmAttributes.AssetKind.REPOSITORY_ROOT.toString());
    }

    public boolean shouldSkipAttributes(FluentAsset asset) {
        this.logFiltering(asset);
        return !asset.kind().equals(NpmAttributes.AssetKind.TARBALL.toString());
    }

    public String getAssetExportPath(FluentAsset asset) {
        this.logFiltering(asset);
        if (asset.kind().equals(NpmAttributes.AssetKind.PACKAGE_ROOT.toString())) {
            String pathWithoutScope = asset.path();
            this.log.debug("Calculating Asset Export Path for {}", (Object)pathWithoutScope);
            if (pathWithoutScope.startsWith("@", 1) && pathWithoutScope.contains("/")) {
                pathWithoutScope = pathWithoutScope.substring(pathWithoutScope.lastIndexOf(47) + 1);
                this.log.debug("Removed scope from path. Result: {}", (Object)pathWithoutScope);
            }
            return String.format("%s/-/%s.package.json", asset.path(), pathWithoutScope);
        }
        return asset.path();
    }

    private void logFiltering(FluentAsset asset) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Filtering npm asset {} as kind: {}", (Object)asset.path(), (Object)asset.kind());
        }
    }
}

