/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm;

import com.google.common.base.Strings;
import com.sonatype.nexus.repository.npm.NpmSearchParameterExtractor;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.view.Parameters;

public abstract class NpmSearchParameterExtractorSupport
extends ComponentSupport
implements NpmSearchParameterExtractor {
    protected static final String WILDCARD = "*";

    @Override
    public int extractSize(Parameters parameters) {
        int size = 20;
        String sizeParameter = Strings.nullToEmpty((String)parameters.get("size")).trim();
        if (!sizeParameter.isEmpty()) {
            try {
                size = Integer.parseInt(sizeParameter);
            }
            catch (NumberFormatException e) {
                this.log.debug("Invalid size encountered in search parameters {}, using default", (Object)parameters, (Object)e);
            }
            if (size < 1) {
                size = 1;
            } else if (size > 250) {
                size = 250;
            }
        }
        return size;
    }

    @Override
    public int extractFrom(Parameters parameters) {
        int from = 0;
        String fromParameter = Strings.nullToEmpty((String)parameters.get("from")).trim();
        if (!fromParameter.isEmpty()) {
            try {
                from = Integer.parseInt(fromParameter);
            }
            catch (NumberFormatException e) {
                this.log.debug("Invalid from encountered in search parameters {}, using default", (Object)parameters, (Object)e);
            }
            if (from < 0) {
                from = 0;
            }
        }
        return from;
    }

    protected String makeWildcardIfNoSearchKeys(String text) {
        if (!text.contains(":")) {
            return WILDCARD + text + WILDCARD;
        }
        return text;
    }
}

