/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm;

import com.sonatype.nexus.repository.npm.internal.NpmPackageId;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class NpmCoordinateUtil {
    private static final Pattern NPM_VERSION_PATTERN = Pattern.compile("-(\\d+\\.\\d+\\.\\d+[A-Za-z\\d\\-.+]*)\\.(?:tar\\.gz|tgz)");
    private static final String PATH_SEPARATOR = "/-/";

    public static String extractVersion(String npmPath) {
        Matcher matcher = NPM_VERSION_PATTERN.matcher(npmPath);
        return matcher.find() ? matcher.group(1) : "";
    }

    public static String extractName(String fullName) {
        int idx = fullName.indexOf(47);
        if (idx != -1) {
            return fullName.substring(idx + 1);
        }
        return fullName;
    }

    public static String extractScope(String fullName) {
        int idx = fullName.indexOf(47);
        if (idx != -1) {
            return fullName.substring("@".length(), idx);
        }
        return null;
    }

    public static String extractFullName(String assetPath) {
        if (assetPath.contains(PATH_SEPARATOR)) {
            String name = StringUtils.removeStart((String)assetPath, (String)"/");
            return name.substring(0, name.indexOf(PATH_SEPARATOR));
        }
        return assetPath;
    }

    @Nullable
    public static String getPackageIdScope(String npmPath) {
        return NpmPackageId.parse(npmPath).scope();
    }

    public static String getPackageIdName(String npmPath) {
        return NpmPackageId.parse(npmPath).name();
    }

    private NpmCoordinateUtil() {
    }
}

