/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm;

import com.google.common.base.Predicate;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.capability.CapabilityReference;
import org.sonatype.nexus.capability.CapabilityReferenceFilterBuilder;
import org.sonatype.nexus.capability.CapabilityRegistry;
import org.sonatype.nexus.capability.CapabilityType;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.stateguard.StateGuard;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.validation.ConstraintViolationFactory;

@Named
public class ConfigurationValidationHelper {
    private static final String NPM_KEY = "npm";
    public static final String NPM_KEY_REMOVE_QUARANTINED_VERSIONS = "removeQuarantinedVersions";
    public static final String ATTRIBUTES_NPM_REMOVE_QUARANTINED_VERSIONS = "attributes.npm.removeQuarantinedVersions";
    public static final String FIREWALL_SERVER_MUST_ENABLED_MESSAGE = "Firewall Server must be enabled.";
    public static final String FIREWALL_AUDIT_AND_QUARANTINE_CAPABILITY_MUST_BE_ENABLED_MESSAGE = "Firewall Audit And Quarantine capability must be enabled and Quarantine feature must be on.";
    public static final String CLM_TYPE_ID = "clm";
    public static final String FIREWALL_AUDIT_TYPE_ID = "firewall.audit";
    public static final String QUARANTINE_KEY = "quarantine";
    public static final String REPOSITORY_KEY = "repository";
    private final CapabilityRegistry capabilityRegistry;
    private final ConstraintViolationFactory constraintViolationFactory;

    @Inject
    public ConfigurationValidationHelper(CapabilityRegistry capabilityRegistry, ConstraintViolationFactory constraintViolationFactory) {
        this.capabilityRegistry = capabilityRegistry;
        this.constraintViolationFactory = constraintViolationFactory;
    }

    public void validate(Configuration configuration, StateGuard stateGuard) throws ConstraintViolationException {
        this.validateNpmProxySection(configuration, stateGuard);
    }

    private void validateNpmProxySection(Configuration configuration, StateGuard stateGuard) {
        if (stateGuard.is("STARTED")) {
            NestedAttributesMap npm = configuration.attributes(NPM_KEY);
            Boolean removeQuarantinedVersions = (Boolean)npm.get(NPM_KEY_REMOVE_QUARANTINED_VERSIONS, Boolean.class, (Object)false);
            HashSet violations = new HashSet();
            if (removeQuarantinedVersions.booleanValue()) {
                if (!this.isClmCapabilityPresentAndEnabled()) {
                    this.fillViolations(violations, removeQuarantinedVersions, FIREWALL_SERVER_MUST_ENABLED_MESSAGE);
                    throw new ConstraintViolationException(violations);
                }
                if (!this.isFirewallAuditCapabilityEnabledAndQuarantineEnabled(configuration.getRepositoryName())) {
                    this.fillViolations(violations, removeQuarantinedVersions, FIREWALL_AUDIT_AND_QUARANTINE_CAPABILITY_MUST_BE_ENABLED_MESSAGE);
                    throw new ConstraintViolationException(violations);
                }
            }
        }
    }

    private Set<ConstraintViolation<?>> fillViolations(Set<ConstraintViolation<?>> violations, Boolean removeQuarantinedVersions, String message) {
        if (removeQuarantinedVersions.booleanValue()) {
            violations.add(this.constraintViolationFactory.createViolation(ATTRIBUTES_NPM_REMOVE_QUARANTINED_VERSIONS, message));
        }
        return violations;
    }

    private boolean isClmCapabilityPresentAndEnabled() {
        return this.capabilityRegistry.get((Predicate)CapabilityReferenceFilterBuilder.capabilities().withType(CapabilityType.capabilityType((String)CLM_TYPE_ID)).includeNotExposed().enabled()).stream().findFirst().isPresent();
    }

    private boolean isFirewallAuditCapabilityEnabledAndQuarantineEnabled(String repositoryName) {
        Optional auditCapability = this.capabilityRegistry.get((Predicate)CapabilityReferenceFilterBuilder.capabilities().withType(CapabilityType.capabilityType((String)FIREWALL_AUDIT_TYPE_ID)).withProperty(REPOSITORY_KEY, repositoryName).enabled()).stream().findFirst();
        if (!auditCapability.isPresent()) {
            return false;
        }
        return this.parseBoolean((String)((CapabilityReference)auditCapability.get()).context().properties().get(QUARANTINE_KEY), false);
    }

    private Boolean parseBoolean(@Nullable String value, @Nullable Boolean defaultValue) {
        if (!StringUtils.isEmpty((CharSequence)value)) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }
}

