/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.content.npm.upgrade;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.upgrade.datastore.RepeatableDatabaseMigrationStep;

@Named
@Singleton
public class NpmPCCSAndFirewallAuditCapabilityOutOfSyncMigrationStep
extends RepeatableDatabaseMigrationStep {
    public void migrate(Connection connection) throws Exception {
        List<RepositoryDTO> repositories = this.getNpmProxyRepositories(connection);
        List<FirewallAuditCapabilityDTO> firewallAuditCapabilities = this.getFirewallAuditCapabilities(connection);
        for (RepositoryDTO repository : repositories) {
            FirewallAuditCapabilityDTO firewallAuditCapability = this.getFirewallAuditCapability(firewallAuditCapabilities, repository.name).orElse(null);
            if (!this.isFirewallAuditCapabilityDisabled(firewallAuditCapability)) continue;
            this.disablePCCS(connection, repository);
        }
    }

    public Integer getChecksum() {
        return 1;
    }

    private boolean isFirewallAuditCapabilityDisabled(@Nullable FirewallAuditCapabilityDTO firewallAuditCapability) {
        return firewallAuditCapability == null || !firewallAuditCapability.enabled || !firewallAuditCapability.quarantine;
    }

    private void disablePCCS(Connection connection, RepositoryDTO repositoryDTO) throws Exception {
        if (!repositoryDTO.removeQuarantinedVersions) {
            return;
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (PreparedStatement preparedStatement = connection.prepareStatement("update repository set attributes = ? where recipe_name = 'npm-proxy' and name = ?");){
            ObjectMapper objectMapper = new ObjectMapper();
            this.disableNpmPCCS(repositoryDTO.attributes);
            byte[] attributesAsBytes = objectMapper.writeValueAsBytes((Object)repositoryDTO.attributes);
            if (this.isH2(connection)) {
                preparedStatement.setBytes(1, attributesAsBytes);
            } else if (this.isPostgresql(connection)) {
                preparedStatement.setString(1, new String(attributesAsBytes, StandardCharsets.UTF_8));
            } else {
                throw new UnsupportedOperationException("Unknown db" + connection.getMetaData().getDatabaseProductName());
            }
            preparedStatement.setString(2, repositoryDTO.name);
            preparedStatement.executeUpdate();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void disableNpmPCCS(JsonNode attributeNode) {
        ObjectNode npm = (ObjectNode)attributeNode.get("npm");
        if (npm == null) {
            npm = ((ObjectNode)attributeNode).putObject("npm");
        }
        npm.put("removeQuarantinedVersions", false);
    }

    private List<FirewallAuditCapabilityDTO> getFirewallAuditCapabilities(Connection connection) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try (PreparedStatement preparedStatement = connection.prepareStatement("SELECT enabled as enabled, properties as properties FROM capability_storage_item where type = 'firewall.audit'");){
            ObjectMapper objectMapper = new ObjectMapper();
            ResultSet resultSet = preparedStatement.executeQuery();
            ArrayList<FirewallAuditCapabilityDTO> result = new ArrayList<FirewallAuditCapabilityDTO>();
            while (resultSet.next()) {
                boolean enabled = resultSet.getBoolean("enabled");
                String jsonProperties = resultSet.getString("properties");
                JsonNode jsonNode = objectMapper.readTree(jsonProperties);
                String repository = jsonNode.get("repository").asText();
                boolean quarantine = jsonNode.get("quarantine").asBoolean(false);
                FirewallAuditCapabilityDTO firewallAuditCapabilityDTO = new FirewallAuditCapabilityDTO();
                firewallAuditCapabilityDTO.repository = repository;
                firewallAuditCapabilityDTO.enabled = enabled;
                firewallAuditCapabilityDTO.quarantine = quarantine;
                result.add(firewallAuditCapabilityDTO);
            }
            return result;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private List<RepositoryDTO> getNpmProxyRepositories(Connection connection) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try (PreparedStatement preparedStatement = connection.prepareStatement("select name as name, attributes as attributes from repository where recipe_name = 'npm-proxy'");){
            ObjectMapper objectMapper = new ObjectMapper();
            ResultSet resultSet = preparedStatement.executeQuery();
            ArrayList<RepositoryDTO> repositories = new ArrayList<RepositoryDTO>();
            while (resultSet.next()) {
                String name = resultSet.getString("name");
                String attributesJson = resultSet.getString("attributes");
                JsonNode attributesJsonNode = objectMapper.readTree(attributesJson);
                RepositoryDTO repositoryDTO = new RepositoryDTO();
                repositoryDTO.name = name;
                repositoryDTO.removeQuarantinedVersions = this.extractNpmBooleanAttribute(attributesJsonNode, "removeQuarantinedVersions");
                repositoryDTO.attributes = attributesJsonNode;
                repositories.add(repositoryDTO);
            }
            return repositories;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private boolean extractNpmBooleanAttribute(JsonNode jsonNode, String key) {
        JsonNode npm = jsonNode.get("npm");
        if (npm == null) {
            return false;
        }
        JsonNode node = npm.get(key);
        if (node == null) {
            return false;
        }
        return node.asBoolean(false);
    }

    private Optional<FirewallAuditCapabilityDTO> getFirewallAuditCapability(List<FirewallAuditCapabilityDTO> firewallAuditCapabilities, String repositoryName) {
        return firewallAuditCapabilities.stream().filter(it -> it.repository.equals(repositoryName)).findFirst();
    }

    private static class FirewallAuditCapabilityDTO {
        String repository;
        boolean enabled;
        boolean quarantine;

        private FirewallAuditCapabilityDTO() {
        }
    }

    private static class RepositoryDTO {
        String name;
        boolean removeQuarantinedVersions;
        JsonNode attributes;

        private RepositoryDTO() {
        }
    }
}

