/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.content.npm.internal.search.legacy;

import com.sonatype.nexus.repository.content.npm.internal.NpmFacetSupport;
import com.sonatype.nexus.repository.npm.internal.NpmPackageParser;
import com.sonatype.nexus.repository.npm.internal.search.legacy.NpmSearchIndexFacet;
import com.sonatype.nexus.repository.npm.internal.search.legacy.NpmSearchIndexFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;

@Deprecated
public abstract class NpmSearchIndexFacetCaching
extends NpmFacetSupport
implements NpmSearchIndexFacet {
    private final EventManager eventManager;

    protected NpmSearchIndexFacetCaching(EventManager eventManager, NpmPackageParser npmPackageParser) {
        super(npmPackageParser);
        this.eventManager = eventManager;
    }

    @Override
    @Nonnull
    public Content searchIndex(@Nullable DateTime since) throws IOException {
        Content searchIndex = this.getCachedSearchIndex();
        if (searchIndex == null) {
            searchIndex = this.getSearchIndex();
        }
        return NpmSearchIndexFilter.filterModifiedSince(searchIndex, since);
    }

    @Nullable
    protected Content getCachedSearchIndex() throws IOException {
        return this.getSearchIndex(true);
    }

    protected Content getSearchIndex() throws IOException {
        return this.getSearchIndex(false);
    }

    @Nullable
    private Content getSearchIndex(boolean fromCacheOnly) throws IOException {
        Optional<FluentAsset> packageRootAsset = this.findRepositoryRootAsset();
        if (packageRootAsset.isPresent()) {
            return packageRootAsset.get().download();
        }
        if (fromCacheOnly) {
            return null;
        }
        this.log.debug("Building npm index for {}", (Object)this.getRepository().getName());
        Path path = Files.createTempFile("npm-searchIndex", "json", new FileAttribute[0]);
        try {
            Content content = this.buildIndex(path);
            Content content2 = this.content().putSearchIndex((Payload)content);
            return content2;
        }
        finally {
            Files.delete(path);
        }
    }

    @Override
    public void invalidateCachedSearchIndex() {
        this.deleteAsset();
    }

    protected void deleteAsset() {
        this.log.debug("Invalidating cached npm index of {}", (Object)this.getRepository().getName());
        this.findRepositoryRootAsset().ifPresent(FluentAsset::delete);
    }

    @Nonnull
    protected abstract Content buildIndex(Path var1) throws IOException;
}

