/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.content.npm.internal;

import com.google.common.collect.Maps;
import com.sonatype.nexus.repository.npm.internal.NpmJsonUtils;
import com.sonatype.nexus.repository.npm.internal.NpmVersionComparator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.Status;
import org.sonatype.nexus.repository.view.payloads.BytesPayload;

public final class NpmUtils {
    private NpmUtils() {
    }

    public static InputStream errorInputStream(String message) {
        NestedAttributesMap errorObject = new NestedAttributesMap("error", (Map)Maps.newHashMap());
        errorObject.set("success", (Object)false);
        errorObject.set("error", (Object)("Failed to stream response due to: " + message));
        return new ByteArrayInputStream(NpmJsonUtils.bytes(errorObject));
    }

    private static NestedAttributesMap readDistTagResponse(Payload payload) {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (Payload p = payload;){
                return NpmJsonUtils.parse(() -> ((Payload)p).openInputStream());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static BiConsumer<String, Object> populateLatestVersion(NestedAttributesMap merged) {
        return (k, v) -> {
            if (!merged.contains(k)) {
                merged.set(k, v);
            } else if (k.equals("latest")) {
                String newestVersion = NpmVersionComparator.extractNewestVersion.apply((String)merged.get(k, String.class), (String)v);
                merged.set(k, (Object)newestVersion);
            }
        };
    }

    public static Response mergeDistTagResponse(Map<Repository, Response> responses) {
        List collection = responses.values().stream().map(Response::getPayload).filter(Objects::nonNull).map(NpmUtils::readDistTagResponse).filter(Objects::nonNull).collect(Collectors.toList());
        NestedAttributesMap merged = (NestedAttributesMap)collection.get(0);
        if (collection.size() > 1) {
            collection.subList(1, collection.size()).forEach(response -> response.backing().forEach(NpmUtils.populateLatestVersion(merged)));
        }
        return new Response.Builder().status(Status.success((int)200)).payload((Payload)new BytesPayload(NpmJsonUtils.bytes(merged), "application/json")).build();
    }
}

