/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.content.npm.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.content.npm.NpmContentFacet;
import com.sonatype.nexus.repository.npm.internal.NpmAuditErrorHandler;
import com.sonatype.nexus.repository.npm.internal.NpmAuditFacet;
import com.sonatype.nexus.repository.npm.internal.NpmAuditTarballFacet;
import com.sonatype.nexus.repository.npm.internal.NpmHandlers;
import com.sonatype.nexus.repository.npm.internal.NpmPaths;
import com.sonatype.nexus.repository.npm.internal.NpmPingHandler;
import com.sonatype.nexus.repository.npm.internal.NpmSecurityFacet;
import com.sonatype.nexus.repository.npm.internal.NpmTokenFacet;
import com.sonatype.nexus.repository.npm.internal.NpmWhoamiHandler;
import com.sonatype.nexus.repository.npm.repair.datastore.NpmRepairComponent;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Provider;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.RecipeSupport;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.content.browse.BrowseFacet;
import org.sonatype.nexus.repository.content.search.SearchFacet;
import org.sonatype.nexus.repository.http.PartialFetchHandler;
import org.sonatype.nexus.repository.routing.RoutingRuleHandler;
import org.sonatype.nexus.repository.security.SecurityHandler;
import org.sonatype.nexus.repository.view.ConfigurableViewFacet;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Router;
import org.sonatype.nexus.repository.view.handlers.ConditionalRequestHandler;
import org.sonatype.nexus.repository.view.handlers.ContentHeadersHandler;
import org.sonatype.nexus.repository.view.handlers.ExceptionHandler;
import org.sonatype.nexus.repository.view.handlers.HandlerContributor;
import org.sonatype.nexus.repository.view.handlers.IndexHtmlForwardHandler;
import org.sonatype.nexus.repository.view.handlers.LastDownloadedHandler;
import org.sonatype.nexus.repository.view.handlers.TimingHandler;

abstract class NpmRecipeSupport
extends RecipeSupport {
    protected final Provider<NpmSecurityFacet> securityFacet;
    protected final Provider<ConfigurableViewFacet> viewFacet;
    protected final Provider<NpmContentFacet> contentFacet;
    protected final Provider<SearchFacet> searchFacet;
    protected final Provider<BrowseFacet> browseFacet;
    protected final Provider<NpmRepairComponent> npmRepairComponent;
    protected final ExceptionHandler exceptionHandler;
    protected final TimingHandler timingHandler;
    protected final IndexHtmlForwardHandler indexHtmlForwardHandler;
    protected final SecurityHandler securityHandler;
    protected final PartialFetchHandler partialFetchHandler;
    protected final ConditionalRequestHandler conditionalRequestHandler;
    protected final ContentHeadersHandler contentHeadersHandler;
    protected final LastDownloadedHandler lastDownloadedHandler;
    protected final HandlerContributor handlerContributor;
    protected final Provider<NpmTokenFacet> tokenFacet;
    protected final Provider<NpmAuditFacet> npmAuditFacetProvider;
    protected final Provider<NpmAuditTarballFacet> npmAuditTarballFacetProvider;
    protected final RoutingRuleHandler routingHandler;
    protected final NpmAuditErrorHandler auditErrorHandler;
    protected final Handler auditAnalyticsHandler;
    protected final NpmWhoamiHandler npmWhoamiHandler;
    protected final NpmPingHandler pingHandler;

    protected NpmRecipeSupport(Type type, Format format, Provider<NpmSecurityFacet> securityFacet, Provider<ConfigurableViewFacet> viewFacet, Provider<NpmContentFacet> contentFacet, Provider<SearchFacet> searchFacet, Provider<BrowseFacet> browseFacet, Provider<NpmRepairComponent> npmRepairComponent, ExceptionHandler exceptionHandler, TimingHandler timingHandler, IndexHtmlForwardHandler indexHtmlForwardHandler, SecurityHandler securityHandler, PartialFetchHandler partialFetchHandler, ConditionalRequestHandler conditionalRequestHandler, ContentHeadersHandler contentHeadersHandler, LastDownloadedHandler lastDownloadedHandler, HandlerContributor handlerContributor, Provider<NpmTokenFacet> tokenFacet, Provider<NpmAuditFacet> npmAuditFacetProvider, Provider<NpmAuditTarballFacet> npmAuditTarballFacetProvider, RoutingRuleHandler routingHandler, NpmAuditErrorHandler auditErrorHandler, @Nullable Handler auditAnalyticsHandler, NpmWhoamiHandler npmWhoamiHandler, NpmPingHandler pingHandler) {
        super(type, format);
        this.securityFacet = (Provider)Preconditions.checkNotNull(securityFacet);
        this.viewFacet = (Provider)Preconditions.checkNotNull(viewFacet);
        this.contentFacet = (Provider)Preconditions.checkNotNull(contentFacet);
        this.searchFacet = (Provider)Preconditions.checkNotNull(searchFacet);
        this.browseFacet = (Provider)Preconditions.checkNotNull(browseFacet);
        this.npmRepairComponent = (Provider)Preconditions.checkNotNull(npmRepairComponent);
        this.exceptionHandler = (ExceptionHandler)Preconditions.checkNotNull((Object)exceptionHandler);
        this.timingHandler = (TimingHandler)Preconditions.checkNotNull((Object)timingHandler);
        this.indexHtmlForwardHandler = (IndexHtmlForwardHandler)Preconditions.checkNotNull((Object)indexHtmlForwardHandler);
        this.securityHandler = (SecurityHandler)Preconditions.checkNotNull((Object)securityHandler);
        this.partialFetchHandler = (PartialFetchHandler)Preconditions.checkNotNull((Object)partialFetchHandler);
        this.conditionalRequestHandler = (ConditionalRequestHandler)Preconditions.checkNotNull((Object)conditionalRequestHandler);
        this.contentHeadersHandler = (ContentHeadersHandler)Preconditions.checkNotNull((Object)contentHeadersHandler);
        this.lastDownloadedHandler = (LastDownloadedHandler)Preconditions.checkNotNull((Object)lastDownloadedHandler);
        this.handlerContributor = (HandlerContributor)Preconditions.checkNotNull((Object)handlerContributor);
        this.tokenFacet = (Provider)Preconditions.checkNotNull(tokenFacet);
        this.npmAuditFacetProvider = (Provider)Preconditions.checkNotNull(npmAuditFacetProvider);
        this.npmAuditTarballFacetProvider = (Provider)Preconditions.checkNotNull(npmAuditTarballFacetProvider);
        this.routingHandler = (RoutingRuleHandler)Preconditions.checkNotNull((Object)routingHandler);
        this.auditErrorHandler = (NpmAuditErrorHandler)Preconditions.checkNotNull((Object)auditErrorHandler);
        this.auditAnalyticsHandler = Optional.ofNullable(auditAnalyticsHandler).orElse(Context::proceed);
        this.npmWhoamiHandler = (NpmWhoamiHandler)Preconditions.checkNotNull((Object)npmWhoamiHandler);
        this.pingHandler = (NpmPingHandler)Preconditions.checkNotNull((Object)pingHandler);
    }

    void createUserRoutes(Router.Builder builder) {
        builder.route(NpmPaths.userMatcher("PUT").handler((Handler)this.timingHandler).handler(NpmHandlers.npmErrorHandler).handler(NpmHandlers.createToken).create());
        builder.route(NpmPaths.tokenMatcher("DELETE").handler((Handler)this.timingHandler).handler((Handler)this.securityHandler).handler(NpmHandlers.npmErrorHandler).handler(NpmHandlers.deleteToken).create());
    }
}

