/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.content.npm.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.content.npm.NpmContentFacet;
import com.sonatype.nexus.repository.npm.internal.NpmQuarantinedVersionFacetSupport;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.audit.AuditRecorder;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.cache.CacheManager;
import org.sonatype.nexus.cache.NexusCache;
import org.sonatype.nexus.capability.CapabilityRegistry;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.repository.config.Configuration;

@Named
public class NpmQuarantinedVersionFacetImpl
extends NpmQuarantinedVersionFacetSupport {
    private final CacheManager<String, String> cacheManager;
    private volatile NexusCache<String, String> allowedVersionsCache;
    private ReentrantReadWriteLock allowedVersionsCacheLock = new ReentrantReadWriteLock();
    private final ObjectReader reader;
    private final ObjectWriter writer;

    @Inject
    public NpmQuarantinedVersionFacetImpl(EventManager eventManager, CapabilityRegistry capabilityRegistry, CacheManager<String, String> cacheManager, @Named(value="${nexus.npm.firewall.quarantined_versions_timeout_seconds:-10}") @Named(value="${nexus.npm.firewall.quarantined_versions_timeout_seconds:-10}") int quarantinedVersionsTimeoutInSeconds, AuditRecorder auditRecorder, ObjectMapper mapper) {
        super(eventManager, capabilityRegistry, quarantinedVersionsTimeoutInSeconds, auditRecorder);
        this.cacheManager = (CacheManager)Preconditions.checkNotNull(cacheManager);
        this.reader = ((ObjectMapper)Preconditions.checkNotNull((Object)mapper)).readerFor(Package.class);
        this.writer = mapper.writerFor(Package.class);
    }

    @VisibleForTesting
    protected void doInit(Configuration configuration) throws Exception {
        super.doInit(configuration);
    }

    @Override
    public Optional<Blob> getBlob(BlobRef blobRef) {
        return ((NpmContentFacet)this.getRepository().facet(NpmContentFacet.class)).blobs().blob(blobRef);
    }

    @Override
    public Optional<List<String>> get(String packageId) {
        this.allowedVersionsCacheLock.readLock().lock();
        try {
            this.maybeCreateCache();
            Optional<List<String>> optional = this.allowedVersionsCache.get((Object)packageId).map(this::deserialize).flatMap(v -> v.map(Package::getAllowedVersions));
            return optional;
        }
        finally {
            this.allowedVersionsCacheLock.readLock().unlock();
        }
    }

    @Override
    public void put(String packageId, List<String> allowedVersions) {
        this.allowedVersionsCacheLock.writeLock().lock();
        try {
            this.maybeCreateCache();
            this.allowedVersionsCache.put((Object)packageId, (Object)this.serialize(packageId, allowedVersions));
        }
        finally {
            this.allowedVersionsCacheLock.writeLock().unlock();
        }
    }

    private String serialize(String packageId, List<String> allowedVersions) {
        try {
            return this.writer.writeValueAsString((Object)new Package(allowedVersions));
        }
        catch (IOException e) {
            this.log.debug("An error occurred serializing NPM package versions for packageId {}: {}", new Object[]{packageId, allowedVersions, e});
            throw new UncheckedIOException("An error occurred serializing NPM package versions for packageId " + packageId, e);
        }
    }

    private Optional<Package> deserialize(String versions) {
        try {
            return Optional.of((Package)this.reader.readValue(versions, Package.class));
        }
        catch (IOException e) {
            this.log.warn("Failed to deserialize NPM package versions from '{}'", (Object)versions, (Object)e);
            return Optional.empty();
        }
    }

    private void maybeCreateCache() {
        if (this.allowedVersionsCache == null) {
            this.log.debug("Creating {} cache for: {}", (Object)"NPM_FIREWALL_ALLOWED_VERSIONS", (Object)this.getRepository());
            this.allowedVersionsCache = this.cacheManager.getCache(this.getCacheName(), String.class, String.class, this.getCacheDuration());
            this.log.debug("Created {} cache for: {}", (Object)"NPM_FIREWALL_ALLOWED_VERSIONS", (Object)this.getRepository());
        }
    }

    protected void destroyCache() {
        if (this.allowedVersionsCache != null) {
            this.log.debug("Destroying {} cache for: {}", (Object)"NPM_FIREWALL_ALLOWED_VERSIONS", (Object)this.getRepository());
            this.allowedVersionsCache.removeAll();
            this.cacheManager.destroyCache(this.getCacheName());
            this.allowedVersionsCache = null;
            this.log.debug("Destroyed {} cache for: {}", (Object)"NPM_FIREWALL_ALLOWED_VERSIONS", (Object)this.getRepository());
        }
    }

    static final class Package {
        private List<String> allowedVersions;

        public Package() {
        }

        public Package(List<String> allowedVersions) {
            this.allowedVersions = allowedVersions;
        }

        public List<String> getAllowedVersions() {
            return this.allowedVersions;
        }
    }
}

