/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.content.npm.internal;

import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import com.sonatype.nexus.repository.content.npm.INpmHostedFacet;
import com.sonatype.nexus.repository.content.npm.NpmContentFacet;
import com.sonatype.nexus.repository.content.npm.internal.NpmFacetSupport;
import com.sonatype.nexus.repository.content.npm.internal.NpmRequestParser;
import com.sonatype.nexus.repository.npm.internal.NpmFieldFactory;
import com.sonatype.nexus.repository.npm.internal.NpmMetadataUtils;
import com.sonatype.nexus.repository.npm.internal.NpmPackageId;
import com.sonatype.nexus.repository.npm.internal.NpmPackageParser;
import com.sonatype.nexus.repository.npm.internal.NpmPackageRootMetadataUtils;
import com.sonatype.nexus.repository.npm.internal.NpmPublishRequest;
import com.sonatype.nexus.repository.npm.internal.NpmVersionComparator;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.app.VersionComparator;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.entity.Continuations;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.repository.MissingBlobException;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.fluent.FluentQuery;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

@Named
public class NpmHostedFacetImpl
extends NpmFacetSupport
implements INpmHostedFacet {
    private final NpmRequestParser npmRequestParser;

    @Inject
    public NpmHostedFacetImpl(NpmRequestParser npmRequestParser, NpmPackageParser npmPackageParser) {
        super(npmPackageParser);
        this.npmRequestParser = npmRequestParser;
    }

    @Override
    public void deleteDistTags(NpmPackageId packageId, String tag, Payload payload) throws IOException {
        Preconditions.checkNotNull((Object)packageId);
        Preconditions.checkNotNull((Object)tag);
        this.log.debug("Deleting distTags: {}", (Object)packageId);
        if ("latest".equals(tag)) {
            throw new IOException("Unable to delete latest");
        }
        try {
            this.deleteDistTags(packageId, tag);
        }
        catch (IOException e) {
            this.log.info("Unable to obtain dist-tags for {}", (Object)packageId.id(), (Object)e);
        }
    }

    @Override
    public Set<String> deletePackage(NpmPackageId packageId, String revision) throws IOException {
        return this.deletePackage(packageId, revision, true);
    }

    @Override
    public Set<String> deletePackage(NpmPackageId packageId, @Nullable String revision, boolean deleteBlobs) throws IOException {
        Preconditions.checkNotNull((Object)packageId);
        Optional<Object> oldPackageRoot = Optional.empty();
        try {
            oldPackageRoot = NpmHostedFacetImpl.loadPackageRoot(packageId, this.content());
        }
        catch (MissingBlobException missingBlobException) {
            this.log.debug("Exception in loadPackageRoot for package: {}", (Object)packageId);
            try {
                if (this.content().delete(packageId)) {
                    return Collections.singleton(NpmContentFacet.metadataPath(packageId));
                }
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        if (revision != null) {
            oldPackageRoot.ifPresent(attr -> Preconditions.checkArgument((boolean)revision.equals(attr.get("_rev", String.class))));
            return Collections.singleton(NpmContentFacet.tarballPath(packageId, revision));
        }
        HashSet<String> deletedPaths = new HashSet<String>();
        ((NestedAttributesMap)oldPackageRoot.get()).child("versions").keys().forEach(version -> {
            try {
                if (this.content().delete(packageId, (String)version)) {
                    deletedPaths.add(NpmContentFacet.tarballPath(packageId, version));
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        if (this.content().delete(packageId)) {
            deletedPaths.add(NpmContentFacet.metadataPath(packageId));
        }
        return deletedPaths;
    }

    @Override
    public Optional<String> deleteTarball(NpmPackageId packageId, String tarballName) throws IOException {
        return this.deleteTarball(packageId, tarballName, true);
    }

    @Override
    public void recalculateLatestBySemanticVersion(NpmPackageId packageId) throws IOException {
        Iterable<FluentComponent> components = this.getFluentComponents(packageId);
        String maxVersion = StreamSupport.stream(components.spliterator(), false).max((o1, o2) -> VersionComparator.INSTANCE.compare(o1.version(), o2.version())).map(Component::version).orElse(null);
        if (StringUtils.isEmpty((CharSequence)maxVersion)) {
            return;
        }
        NestedAttributesMap packageRoot = NpmHostedFacetImpl.loadPackageRoot(packageId, this.content()).orElse(null);
        if (packageRoot == null) {
            return;
        }
        packageRoot.child("dist-tags").set("latest", (Object)maxVersion);
        this.savePackageRoot(packageId, packageRoot);
    }

    @Override
    public Optional<String> deleteTarball(NpmPackageId packageId, String tarballName, boolean deleteBlob) throws IOException {
        Preconditions.checkNotNull((Object)packageId);
        Preconditions.checkNotNull((Object)tarballName);
        Optional<FluentAsset> tarballAsset = this.findTarballAsset(packageId, tarballName).filter(FluentAsset::delete);
        if (!tarballAsset.isPresent()) {
            return Optional.empty();
        }
        tarballAsset.flatMap(Asset::component).flatMap(component -> this.findPackageTarballComponent(packageId, component.version())).ifPresent(FluentComponent::delete);
        return tarballAsset.map(Asset::path);
    }

    @Override
    public Optional<Content> getDistTags(NpmPackageId packageId) throws IOException {
        Preconditions.checkNotNull((Object)packageId);
        this.log.debug("Getting package: {}", (Object)packageId);
        try {
            NestedAttributesMap packageRoot = NpmHostedFacetImpl.loadPackageRoot(packageId, this.content()).orElse(null);
            if (packageRoot == null) {
                return Optional.empty();
            }
            NestedAttributesMap distTags = packageRoot.child("dist-tags");
            return Optional.of(NpmHostedFacetImpl.distTagsToContent(distTags));
        }
        catch (IOException e) {
            this.log.info("Unable to obtain dist-tags for {}", (Object)packageId.id(), (Object)e);
            return Optional.empty();
        }
    }

    @Override
    public Optional<Content> getPackage(NpmPackageId packageId) throws IOException {
        NestedAttributesMap packageRoot = NpmHostedFacetImpl.loadPackageRoot(packageId, this.content()).orElse(null);
        if (packageRoot == null) {
            return Optional.empty();
        }
        String revision = (String)packageRoot.get("_rev", String.class);
        return this.content().get(packageId).map(NpmFacetSupport::toNpmContent).map(content -> content.fieldMatchers(Arrays.asList(NpmFieldFactory.missingRevFieldMatcher(() -> revision), NpmFieldFactory.rewriteTarballUrlMatcher(this.getRepository().getName(), packageId.id())))).map(content -> content.packageId(packageId.id()));
    }

    @Override
    public Optional<Content> getTarball(NpmPackageId packageId, String tarballName) throws IOException {
        return this.findTarballAsset(packageId, tarballName).map(FluentAsset::download);
    }

    @Override
    public void putDistTags(NpmPackageId packageId, String tag, Payload payload) throws IOException {
        Preconditions.checkNotNull((Object)packageId);
        Preconditions.checkNotNull((Object)tag);
        this.log.debug("Updating distTags: {}", (Object)packageId);
        if ("latest".equals(tag)) {
            throw new IOException("Unable to update latest tag");
        }
        String version = this.parseVersionToTag(packageId, tag, payload);
        this.doPutDistTags(packageId, tag, version);
    }

    protected void doPutDistTags(NpmPackageId packageId, String tag, String version) throws IOException {
        Optional<Content> packageRootAsset = this.content().get(packageId);
        if (!packageRootAsset.isPresent()) {
            return;
        }
        if (!this.findPackageTarballComponent(packageId, version).isPresent()) {
            throw new IOException(String.format("version %s of package %s is not present in repository %s", version, packageId.id(), this.getRepository().getName()));
        }
        try {
            this.updateDistTags(packageId, tag, version);
        }
        catch (IOException e) {
            this.log.error(MessageFormat.format("Unable to update dist-tags for {}", packageId.id()), (Throwable)e);
        }
    }

    @Override
    public void attachDistTags(NpmPackageId packageId, Map<String, Object> distTagsDominant) throws IOException {
        this.log.debug("Attaching Dist Tags to {}", (Object)packageId);
        Optional<NestedAttributesMap> packageRoot = NpmHostedFacetImpl.loadPackageRoot(packageId, (NpmContentFacet)this.getRepository().facet(NpmContentFacet.class));
        if (packageRoot.isPresent()) {
            Map distTags = (Map)packageRoot.get().get("dist-tags", new HashMap());
            for (Map.Entry<String, Object> distTag : distTagsDominant.entrySet()) {
                String tagName = distTag.getKey();
                String tagValue = String.valueOf(distTag.getValue());
                if ("latest".equals(tagName) && distTags.containsKey("latest")) {
                    this.log.debug("Skipped setting latest for {} as already exists. Existing: {}, New: {}", new Object[]{packageId, distTags.get("latest"), tagValue});
                    continue;
                }
                if (distTags.containsKey(tagName)) continue;
                this.updateDistTagIfComponentPresent(packageId, tagName, tagValue);
            }
        } else {
            this.log.warn("No PackageRoot found for npm package: {}", (Object)packageId);
        }
    }

    private void updateDistTagIfComponentPresent(NpmPackageId packageId, String tagName, String value) {
        block5: {
            if (this.findPackageTarballComponent(packageId, value).isPresent()) {
                try {
                    this.doPutDistTags(packageId, tagName, value);
                }
                catch (IOException e) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Unable to update dist-tags for {}", (Object)packageId.id(), (Object)e);
                        break block5;
                    }
                    this.log.warn("Unable to update dist-tags for {}", (Object)packageId.id());
                }
            } else {
                this.log.warn("Unable to find component for dist-tags: {}", (Object)(this.log.isWarnEnabled() ? packageId.id() : null));
            }
        }
    }

    @Override
    public void putPackage(NpmPackageId packageId, String revision, Payload payload) throws IOException {
        Preconditions.checkNotNull((Object)packageId);
        Preconditions.checkNotNull((Object)payload);
        Throwable throwable = null;
        Object var5_6 = null;
        try (NpmPublishRequest request = this.npmRequestParser.parsePublish(this.getRepository(), payload);){
            this.putPublishRequest(packageId, revision, request);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Content putPackage(Map<String, Object> packageJson, Payload payload) throws IOException {
        Preconditions.checkNotNull(packageJson);
        Preconditions.checkNotNull((Object)payload);
        this.log.debug("Storing package: {}", packageJson);
        Preconditions.checkNotNull((Object)packageJson.get("name"), (Object)"Uploaded package is invalid, or is missing package.json");
        String version = (String)packageJson.get("version");
        NpmPackageId packageId = NpmPackageId.parse((String)Preconditions.checkNotNull((Object)packageJson.get("name")));
        Throwable throwable = null;
        Object var6_7 = null;
        try (TempBlob tempBlob = this.content().blobs().ingest(payload, (Iterable)HASH_ALGORITHMS);){
            this.putPackageRoot(packageJson, packageId, ((HashCode)tempBlob.getHashes().get(HashAlgorithm.SHA1)).toString());
            Map<String, Object> npmAttributes = this.maybeExtractFormatAttributes(packageId.id(), version, () -> ((TempBlob)tempBlob).get());
            return this.content().put(packageId, version, npmAttributes, tempBlob);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public FluentAsset putPackageBlob(Map<String, Object> packageJson, Blob blob, HashCode hashCode) throws IOException {
        Preconditions.checkNotNull(packageJson);
        Preconditions.checkNotNull((Object)blob);
        this.log.debug("Storing package: {}", packageJson);
        Preconditions.checkNotNull((Object)packageJson.get("name"), (Object)"Uploaded package is invalid, or is missing package.json");
        NpmPackageId packageId = NpmPackageId.parse((String)Preconditions.checkNotNull((Object)packageJson.get("name")));
        String version = (String)packageJson.get("version");
        this.putPackageRoot(packageJson, packageId, hashCode.toString());
        Map<String, Object> npmAttributes = this.maybeExtractFormatAttributes(packageId.id(), version, () -> ((Blob)blob).getInputStream());
        return this.content().saveTarball(packageId, version, npmAttributes, blob);
    }

    private void putPackageRoot(Map<String, Object> packageJson, NpmPackageId packageId, String sha1Hash) throws IOException {
        NestedAttributesMap metadata = NpmPackageRootMetadataUtils.createFullPackageMetadata(new NestedAttributesMap("metadata", packageJson), this.getRepository().getName(), sha1Hash, "", NpmVersionComparator.extractAlwaysPackageVersion);
        this.putPackageRoot(packageId, null, metadata);
    }

    @Override
    public void putPackageRoot(NpmPackageId packageId, String revision, NestedAttributesMap newPackageRoot) throws IOException {
        boolean update = false;
        NestedAttributesMap packageRoot = newPackageRoot;
        NestedAttributesMap oldPackageRoot = NpmHostedFacetImpl.loadPackageRoot(packageId, this.content()).orElse(null);
        if (oldPackageRoot != null) {
            String rev = revision;
            if (rev == null) {
                rev = (String)packageRoot.get("_rev", String.class);
            }
            if (rev != null) {
                Preconditions.checkArgument((boolean)rev.equals(oldPackageRoot.get("_rev", String.class)));
                update = true;
            } else {
                packageRoot = NpmMetadataUtils.overlay(oldPackageRoot, packageRoot);
            }
        }
        this.updateRevision(packageRoot, NpmContentFacet.metadataPath(packageId), oldPackageRoot == null);
        this.savePackageRoot(packageId, packageRoot);
        if (update) {
            this.updateDeprecationFlags(packageId, packageRoot);
        }
    }

    private void updateRevision(NestedAttributesMap packageRoot, String path, boolean createdPackageRoot) {
        String newRevision = "1";
        if (!createdPackageRoot) {
            if (packageRoot.contains("_rev")) {
                String rev = (String)packageRoot.get("_rev", String.class);
                newRevision = Integer.toString(Integer.parseInt(rev) + 1);
            } else {
                newRevision = "1";
            }
        }
        packageRoot.set("_id", (Object)path.substring(1));
        packageRoot.set("_rev", (Object)newRevision);
    }

    private void updateDeprecationFlags(NpmPackageId packageId, NestedAttributesMap packageRoot) {
        NestedAttributesMap versions = packageRoot.child("versions");
        for (String componentVersion : this.findPackageTarballComponents(packageId)) {
            this.findPackageTarballComponent(packageId, componentVersion).ifPresent(tarballComponent -> {
                boolean deprecated;
                Preconditions.checkState((boolean)versions.contains(tarballComponent.version()), (String)"Package %s lacks tarball version %s", (Object)packageId, (Object)tarballComponent.version());
                NestedAttributesMap version = versions.child(tarballComponent.version());
                String deprecationMessage = (String)version.get("deprecated", String.class);
                boolean bl = deprecated = !Strings2.isBlank((String)deprecationMessage);
                if (deprecated && !deprecationMessage.equals(tarballComponent.attributes().get("deprecated", String.class))) {
                    tarballComponent.withAttribute("deprecated", (Object)deprecationMessage);
                } else if (!deprecated && tarballComponent.attributes().contains("deprecated")) {
                    tarballComponent.withoutAttribute("deprecated");
                }
            });
        }
    }

    protected void putPublishRequest(NpmPackageId packageId, @Nullable String revision, NpmPublishRequest request) throws IOException {
        this.log.debug("Storing package: {}", (Object)packageId);
        NestedAttributesMap packageRoot = request.getPackageRoot();
        NestedAttributesMap attachments = packageRoot.child("_attachments");
        if (!attachments.isEmpty()) {
            for (String name : attachments.keys()) {
                NestedAttributesMap attachment = attachments.child(name);
                NestedAttributesMap packageVersion = NpmMetadataUtils.selectVersionByTarballName(packageRoot, name);
                this.putTarball(packageId, packageVersion, attachment, request);
            }
        }
        this.putPackageRoot(packageId, revision, packageRoot);
    }

    private void putTarball(NpmPackageId packageId, NestedAttributesMap packageVersion, NestedAttributesMap attachment, NpmPublishRequest request) throws IOException {
        String tarballName = NpmMetadataUtils.extractTarballName(attachment.getKey());
        String version = (String)packageVersion.get("version", String.class);
        this.log.debug("Storing tarball: {}@{} ({})", new Object[]{packageId, version, tarballName});
        Throwable throwable = null;
        Object var8_9 = null;
        try (TempBlob tempBlob = request.requireBlob((String)attachment.require("data", String.class));){
            Map<String, Object> npmAttributes = this.maybeExtractFormatAttributes(packageId.id(), version, () -> ((TempBlob)tempBlob).get());
            this.content().put(packageId, version, npmAttributes, tempBlob);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private String parseVersionToTag(NpmPackageId packageId, @Nullable String tag, Payload payload) throws IOException {
        String version;
        Throwable throwable = null;
        Object var6_6 = null;
        try (InputStream is = payload.openInputStream();){
            version = IOUtils.toString((InputStream)is).replaceAll("\"", "");
            this.log.debug("Adding tag {}:{} to {}", new Object[]{tag, version, packageId});
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return version;
    }

    private Iterable<FluentComponent> getFluentComponents(NpmPackageId packageId) {
        String filterString = " name = #{filterParams.name}";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", packageId.name());
        if (StringUtils.isNotEmpty((CharSequence)packageId.scope())) {
            filterString = String.valueOf(filterString) + " and namespace = #{filterParams.scope}";
            params.put("scope", packageId.scope());
        }
        FluentQuery fluentComponentFluentQuery = this.content().components().byFilter(filterString, params);
        return Continuations.iterableOf((arg_0, arg_1) -> ((FluentQuery)fluentComponentFluentQuery).browse(arg_0, arg_1));
    }
}

