/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.content.npm.internal;

import com.sonatype.nexus.repository.content.npm.NpmContentFacet;
import com.sonatype.nexus.repository.content.npm.internal.NpmGroupDataFacet;
import com.sonatype.nexus.repository.content.npm.internal.NpmGroupDistTagsHandler;
import com.sonatype.nexus.repository.content.npm.internal.NpmGroupPackageHandler;
import com.sonatype.nexus.repository.content.npm.internal.NpmRecipeSupport;
import com.sonatype.nexus.repository.content.npm.internal.search.legacy.NpmSearchIndexFacetGroup;
import com.sonatype.nexus.repository.npm.internal.NpmAuditErrorHandler;
import com.sonatype.nexus.repository.npm.internal.NpmAuditFacet;
import com.sonatype.nexus.repository.npm.internal.NpmAuditTarballFacet;
import com.sonatype.nexus.repository.npm.internal.NpmGroupAuditHandler;
import com.sonatype.nexus.repository.npm.internal.NpmGroupAuditQuickHandler;
import com.sonatype.nexus.repository.npm.internal.NpmGroupWriteHandler;
import com.sonatype.nexus.repository.npm.internal.NpmHandlers;
import com.sonatype.nexus.repository.npm.internal.NpmPaths;
import com.sonatype.nexus.repository.npm.internal.NpmPingHandler;
import com.sonatype.nexus.repository.npm.internal.NpmSecurityFacet;
import com.sonatype.nexus.repository.npm.internal.NpmTokenFacet;
import com.sonatype.nexus.repository.npm.internal.NpmWhoamiHandler;
import com.sonatype.nexus.repository.npm.internal.search.v1.NpmSearchGroupHandler;
import com.sonatype.nexus.repository.npm.repair.datastore.NpmRepairComponent;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.upgrade.AvailabilityVersion;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.content.browse.BrowseFacet;
import org.sonatype.nexus.repository.content.search.SearchFacet;
import org.sonatype.nexus.repository.group.GroupFacet;
import org.sonatype.nexus.repository.group.GroupHandler;
import org.sonatype.nexus.repository.http.HttpHandlers;
import org.sonatype.nexus.repository.http.PartialFetchHandler;
import org.sonatype.nexus.repository.recipe.RouterBuilder;
import org.sonatype.nexus.repository.routing.RoutingRuleHandler;
import org.sonatype.nexus.repository.security.SecurityHandler;
import org.sonatype.nexus.repository.view.ConfigurableViewFacet;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Router;
import org.sonatype.nexus.repository.view.handlers.ConditionalRequestHandler;
import org.sonatype.nexus.repository.view.handlers.ContentHeadersHandler;
import org.sonatype.nexus.repository.view.handlers.ExceptionHandler;
import org.sonatype.nexus.repository.view.handlers.HandlerContributor;
import org.sonatype.nexus.repository.view.handlers.IndexHtmlForwardHandler;
import org.sonatype.nexus.repository.view.handlers.LastDownloadedHandler;
import org.sonatype.nexus.repository.view.handlers.TimingHandler;

@AvailabilityVersion(from="1.0")
@Named(value="npm-group")
@Singleton
class NpmGroupRecipe
extends NpmRecipeSupport {
    public static final String NAME = "npm-group";
    @Inject
    Provider<NpmGroupDataFacet> npmGroupFacet;
    @Inject
    Provider<NpmSearchIndexFacetGroup> npmSearchIndexFacet;
    @Inject
    NpmGroupPackageHandler packageHandler;
    @Inject
    NpmGroupDistTagsHandler distTagsHandler;
    @Inject
    Provider<GroupFacet> groupFacet;
    @Inject
    @Named(value="groupWriteFacet")
    Provider<GroupFacet> writeableGroupFacet;
    @Inject
    NpmGroupWriteHandler groupWriteHandler;
    @Inject
    GroupHandler tarballHandler;
    @Inject
    NpmSearchGroupHandler searchHandler;
    @Inject
    NpmGroupAuditHandler npmGroupAuditHandler;
    @Inject
    NpmGroupAuditQuickHandler npmGroupAuditQuickHandler;
    @Inject
    @Named(value="nexus.analytics.npmGroupDeployHandler")
    @Nullable
    Handler npmGroupDeployAnalyticsHandler;

    @Inject
    public NpmGroupRecipe(@Named(value="group") @Named(value="group") Type type, @Named(value="npm") @Named(value="npm") Format format, Provider<NpmSecurityFacet> securityFacet, Provider<ConfigurableViewFacet> viewFacet, Provider<BrowseFacet> browseFacet, Provider<SearchFacet> searchFacet, Provider<NpmRepairComponent> npmRepairComponent, Provider<NpmTokenFacet> tokenFacet, Provider<NpmAuditFacet> npmAuditFacetProvider, Provider<NpmAuditTarballFacet> npmAuditTarballFacetProvider, Provider<NpmContentFacet> contentFacet, ExceptionHandler exceptionHandler, TimingHandler timingHandler, IndexHtmlForwardHandler indexHtmlForwardHandler, SecurityHandler securityHandler, PartialFetchHandler partialFetchHandler, ConditionalRequestHandler conditionalRequestHandler, ContentHeadersHandler contentHeadersHandler, LastDownloadedHandler lastDownloadedHandler, HandlerContributor handlerContributor, RoutingRuleHandler routingHandler, NpmAuditErrorHandler auditErrorHandler, NpmWhoamiHandler npmWhoamiHandler, NpmPingHandler pingHandler, @Named(value="nexus.analytics.npmAuditHandler") @Nullable @Named(value="nexus.analytics.npmAuditHandler") @Nullable Handler auditAnalyticsHandler) {
        super(type, format, securityFacet, viewFacet, contentFacet, searchFacet, browseFacet, npmRepairComponent, exceptionHandler, timingHandler, indexHtmlForwardHandler, securityHandler, partialFetchHandler, conditionalRequestHandler, contentHeadersHandler, lastDownloadedHandler, handlerContributor, tokenFacet, npmAuditFacetProvider, npmAuditTarballFacetProvider, routingHandler, auditErrorHandler, auditAnalyticsHandler, npmWhoamiHandler, pingHandler);
    }

    public void apply(@Nonnull Repository repository) throws Exception {
        repository.attach(this.writeableGroupFacet.get() != null ? (Facet)this.writeableGroupFacet.get() : (Facet)this.groupFacet.get());
        repository.attach((Facet)this.npmGroupFacet.get());
        repository.attach((Facet)this.contentFacet.get());
        repository.attach((Facet)this.securityFacet.get());
        repository.attach((Facet)this.tokenFacet.get());
        repository.attach((Facet)this.npmSearchIndexFacet.get());
        repository.attach((Facet)this.npmAuditFacetProvider.get());
        repository.attach((Facet)this.npmAuditTarballFacetProvider.get());
        repository.attach(this.configure((ConfigurableViewFacet)this.viewFacet.get()));
    }

    Facet configure(ConfigurableViewFacet facet) {
        Router.Builder builder = new Router.Builder();
        this.addBrowseUnsupportedRoute((RouterBuilder)builder);
        builder.route(NpmPaths.searchIndexMatcher().handler((Handler)this.timingHandler).handler((Handler)this.securityHandler).handler(NpmHandlers.searchIndex).create());
        builder.route(NpmPaths.searchV1Matcher().handler((Handler)this.timingHandler).handler((Handler)this.securityHandler).handler((Handler)this.searchHandler).create());
        builder.route(NpmPaths.whoamiMatcher().handler((Handler)this.timingHandler).handler((Handler)this.npmWhoamiHandler).create());
        builder.route(NpmPaths.pingMatcher().handler((Handler)this.timingHandler).handler((Handler)this.pingHandler).create());
        builder.route(NpmPaths.auditMatcher().handler(this.auditAnalyticsHandler).handler((Handler)this.timingHandler).handler((Handler)this.securityHandler).handler((Handler)this.auditErrorHandler).handler((Handler)this.npmGroupAuditHandler).create());
        builder.route(NpmPaths.auditQuickMatcher().handler((Handler)this.timingHandler).handler((Handler)this.auditErrorHandler).handler((Handler)this.npmGroupAuditQuickHandler).create());
        builder.route(NpmPaths.packageMatcher("GET", "HEAD").handler((Handler)this.timingHandler).handler((Handler)this.securityHandler).handler((Handler)this.conditionalRequestHandler).handler((Handler)this.contentHeadersHandler).handler((Handler)this.lastDownloadedHandler).handler((Handler)this.packageHandler).create());
        builder.route(NpmPaths.tarballMatcher("GET", "HEAD").handler((Handler)this.timingHandler).handler((Handler)this.securityHandler).handler((Handler)this.handlerContributor).handler((Handler)this.tarballHandler).create());
        builder.route(NpmPaths.distTagsMatcher("GET").handler((Handler)this.timingHandler).handler((Handler)this.securityHandler).handler((Handler)this.lastDownloadedHandler).handler((Handler)this.distTagsHandler).create());
        builder.route(NpmPaths.packageMatcher("PUT").handler(this.npmGroupDeployAnalyticsHandler != null ? this.npmGroupDeployAnalyticsHandler : Context::proceed).handler((Handler)this.timingHandler).handler((Handler)this.securityHandler).handler(NpmHandlers.npmErrorHandler).handler((Handler)this.handlerContributor).handler((Handler)this.conditionalRequestHandler).handler((Handler)this.contentHeadersHandler).handler((Handler)this.groupWriteHandler).create());
        this.createUserRoutes(builder);
        builder.defaultHandlers(new Handler[]{HttpHandlers.badRequest()});
        facet.configure(builder.create());
        return facet;
    }
}

