/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.content.npm.internal;

import com.sonatype.nexus.repository.content.npm.NpmContentFacet;
import com.sonatype.nexus.repository.content.npm.internal.NpmContent;
import com.sonatype.nexus.repository.content.npm.internal.NpmStreamPayload;
import com.sonatype.nexus.repository.npm.internal.NpmFormatAttributesExtractor;
import com.sonatype.nexus.repository.npm.internal.NpmJsonUtils;
import com.sonatype.nexus.repository.npm.internal.NpmMetadataUtils;
import com.sonatype.nexus.repository.npm.internal.NpmPackageId;
import com.sonatype.nexus.repository.npm.internal.NpmPackageParser;
import com.sonatype.nexus.repository.npm.internal.NpmVersionComparator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.sonatype.nexus.common.app.VersionComparator;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.fluent.FluentComponentBuilder;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.Status;
import org.sonatype.nexus.repository.view.payloads.BytesPayload;

public abstract class NpmFacetSupport
extends FacetSupport {
    protected static final List<HashAlgorithm> HASH_ALGORITHMS = Collections.singletonList(HashAlgorithm.SHA1);
    protected static final String REPOSITORY_ROOT_ASSET = "/-/all";
    protected static final String REPOSITORY_SEARCH_ASSET = "/-/v1/search";
    protected final NpmPackageParser npmPackageParser;

    protected NpmFacetSupport(NpmPackageParser npmPackageParser) {
        this.npmPackageParser = npmPackageParser;
    }

    @Nonnull
    public static String tarballAssetName(NpmPackageId packageId, String tarballName) {
        return "/" + packageId.id() + "/-/" + tarballName;
    }

    protected Optional<FluentComponent> findPackageTarballComponent(NpmPackageId packageId, String version) {
        FluentComponentBuilder components = this.content().components().name(packageId.name()).version(version);
        if (packageId.scope() != null) {
            components.namespace(packageId.scope());
        }
        return components.find();
    }

    protected Optional<FluentAsset> findRepositoryRootAsset() {
        return this.findAsset(REPOSITORY_ROOT_ASSET);
    }

    protected Optional<FluentAsset> findAsset(String path) {
        return this.content().assets().path(path).find();
    }

    protected Optional<FluentAsset> findPackageRootAsset(NpmPackageId packageId) {
        return this.findAsset(NpmContentFacet.metadataPath(packageId));
    }

    protected Optional<FluentAsset> findTarballAsset(NpmPackageId packageId, String tarballName) {
        return this.findAsset(NpmFacetSupport.tarballAssetName(packageId, tarballName));
    }

    public static Optional<NestedAttributesMap> loadPackageRoot(NpmPackageId packageId, NpmContentFacet npmContentFacet) throws IOException {
        Optional<Content> content = npmContentFacet.get(packageId);
        if (!content.isPresent()) {
            return Optional.empty();
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (Content c = content.get();){
            NestedAttributesMap metadata = NpmJsonUtils.parse(() -> ((Content)c).openInputStream());
            metadata.set("_id", (Object)NpmContentFacet.metadataPath(packageId));
            return Optional.of(metadata);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected InputStream errorInputStream(String message) {
        NestedAttributesMap errorObject = new NestedAttributesMap("error", new HashMap());
        errorObject.set("success", (Object)false);
        errorObject.set("error", (Object)("Failed to stream response due to: " + message));
        return new ByteArrayInputStream(NpmJsonUtils.bytes(errorObject));
    }

    protected Content createPackageRootContent(NestedAttributesMap packageRoot) throws IOException {
        packageRoot.remove("_id");
        packageRoot.remove("_attachments");
        NpmMetadataUtils.maintainTime(packageRoot);
        byte[] bytes = NpmJsonUtils.bytes(packageRoot);
        return new Content((Payload)new BytesPayload(bytes, "application/json"));
    }

    protected void savePackageRoot(NpmPackageId packageId, NestedAttributesMap packageRoot) throws IOException {
        this.content().put(packageId, (Payload)this.createPackageRootContent(packageRoot));
    }

    protected Iterable<String> findPackageTarballComponents(NpmPackageId packageId) {
        return this.content().components().versions(packageId.scope(), packageId.name());
    }

    static Content distTagsToContent(NestedAttributesMap distTags) throws IOException {
        byte[] bytes = NpmJsonUtils.mapper.writeValueAsBytes((Object)distTags.backing());
        return new Content((Payload)new BytesPayload(bytes, "application/json"));
    }

    protected void updateDistTags(NpmPackageId packageId, String tag, Object version) throws IOException {
        Optional<NestedAttributesMap> optPackageRoot = NpmFacetSupport.loadPackageRoot(packageId, this.content());
        if (optPackageRoot.isPresent()) {
            NestedAttributesMap packageRoot = optPackageRoot.get();
            NestedAttributesMap distTags = packageRoot.child("dist-tags");
            distTags.set(tag, version);
            this.savePackageRoot(packageId, packageRoot);
        }
    }

    protected void deleteDistTags(NpmPackageId packageId, String tag) throws IOException {
        Optional<NestedAttributesMap> optPackageRoot = NpmFacetSupport.loadPackageRoot(packageId, this.content());
        if (!optPackageRoot.isPresent()) {
            return;
        }
        NestedAttributesMap packageRoot = optPackageRoot.get();
        if (packageRoot.contains("dist-tags")) {
            NestedAttributesMap distTags = packageRoot.child("dist-tags");
            distTags.remove(tag);
            this.savePackageRoot(packageId, packageRoot);
        }
    }

    protected void removeDistTagsFromTagsWithVersion(NestedAttributesMap packageRoot, String version) {
        if (packageRoot.contains("dist-tags")) {
            packageRoot.child("dist-tags").entries().removeIf(e -> version.equals(e.getValue()));
            Set versions = ((Map)packageRoot.backing().get("versions")).keySet();
            String latest = versions.stream().max(new VersionComparator()).orElse("");
            packageRoot.child("dist-tags").set("latest", (Object)latest);
        }
    }

    protected Response mergeDistTagResponse(Map<Repository, Response> responses) {
        List collection = responses.values().stream().map(Response::getPayload).filter(Objects::nonNull).map(NpmFacetSupport::readDistTagResponse).filter(Objects::nonNull).collect(Collectors.toList());
        NestedAttributesMap merged = (NestedAttributesMap)collection.get(0);
        if (collection.size() > 1) {
            collection.subList(1, collection.size()).forEach(response -> response.backing().forEach(NpmFacetSupport.populateLatestVersion(merged)));
        }
        return new Response.Builder().status(Status.success((int)200)).payload((Payload)new BytesPayload(NpmJsonUtils.bytes(merged), "application/json")).build();
    }

    protected static NpmContent toNpmContent(Content content) {
        NpmStreamPayload payload = new NpmStreamPayload(() -> ((Content)content).openInputStream(), content.getContentType());
        return new NpmContent(payload, content);
    }

    private static BiConsumer<String, Object> populateLatestVersion(NestedAttributesMap merged) {
        return (k, v) -> {
            if (!merged.contains(k)) {
                merged.set(k, v);
            } else {
                String newestVersion = NpmVersionComparator.extractNewestVersion.apply((String)merged.get(k, String.class), (String)v);
                merged.set(k, (Object)newestVersion);
            }
        };
    }

    private static NestedAttributesMap readDistTagResponse(Payload payload) {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (Payload p = payload;){
                return NpmJsonUtils.parse(() -> ((Payload)p).openInputStream());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected NpmContentFacet content() {
        return (NpmContentFacet)this.getRepository().facet(NpmContentFacet.class);
    }

    protected Map<String, Object> maybeExtractFormatAttributes(String packageId, String version, InputStreamSupplier blob) {
        return NpmFacetSupport.formatAttributeExtractor(packageId, version, blob).apply(this.npmPackageParser, this.log);
    }

    static BiFunction<NpmPackageParser, Logger, Map<String, Object>> formatAttributeExtractor(String packageId, String version, InputStreamSupplier blob) {
        return (npmPackageParser, log) -> {
            Map<String, Object> formatAttributes = npmPackageParser.parsePackageJson(blob);
            if (formatAttributes.isEmpty()) {
                log.warn("No format attributes found in package.json for npm package ID {} version {}, will not be searchable", (Object)packageId, (Object)version);
                return Collections.emptyMap();
            }
            NestedAttributesMap attributes = new NestedAttributesMap("npm", new HashMap());
            NpmFormatAttributesExtractor formatAttributesExtractor = new NpmFormatAttributesExtractor(formatAttributes);
            formatAttributesExtractor.copyFormatAttributes(attributes);
            return attributes.backing();
        };
    }
}

