/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.restore.internal.orient;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.blobstore.restore.internal.orient.NpmRestoreBlobData;
import javax.annotation.Nonnull;
import org.eclipse.aether.util.StringUtils;
import org.sonatype.nexus.blobstore.restore.RestoreBlobData;

public final class NpmRestoreBlobDataFactory {
    private NpmRestoreBlobDataFactory() {
    }

    public static NpmRestoreBlobData create(@Nonnull RestoreBlobData data) {
        Preconditions.checkState((!StringUtils.isEmpty((String)data.getBlobName()) ? 1 : 0) != 0, (Object)"Blob name cannot be empty");
        String[] parts = data.getBlobName().split("/-/");
        if (parts.length == 1) {
            String id = parts[0];
            NpmRestoreBlobData.NpmType type = "-/all".equals(id) ? NpmRestoreBlobData.NpmType.REPOSITORY_ROOT : NpmRestoreBlobData.NpmType.PACKAGE_ROOT;
            return new NpmRestoreBlobData(type, id, null, data);
        }
        return new NpmRestoreBlobData(NpmRestoreBlobData.NpmType.TARBALL, parts[0], parts[1], data);
    }
}

