/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.restore.internal.datastore;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.blobstore.restore.internal.datastore.NpmRestoreBlobData;
import com.sonatype.nexus.repository.content.npm.NpmContentFacet;
import com.sonatype.nexus.repository.npm.repair.datastore.NpmRepairComponent;
import java.io.IOException;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.restore.datastore.BaseRestoreBlobStrategy;
import org.sonatype.nexus.common.log.DryRunPrefix;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;

@Named(value="npm")
@Singleton
public class NpmRestoreBlobStrategy
extends BaseRestoreBlobStrategy<NpmRestoreBlobData> {
    private static final String REPOSITORY_ROOT_ASSET = "-/all";
    private static final String SEARCH_ASSET = "-/v1/search";
    private static final String TARBALL_ASSET_PATH_PREFIX = "/-/";
    private final RepositoryManager repositoryManager;

    @Inject
    protected NpmRestoreBlobStrategy(DryRunPrefix dryRunPrefix, RepositoryManager repositoryManager) {
        super(dryRunPrefix);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
    }

    protected boolean canAttemptRestore(@Nonnull NpmRestoreBlobData data) {
        Repository repository = data.getRepository();
        Optional npmFacet = repository.optionalFacet(NpmContentFacet.class);
        if (!npmFacet.isPresent()) {
            this.log.warn("Skipping as NPM Facet not found on repository: {}", (Object)repository.getName());
            return false;
        }
        return true;
    }

    protected void createAssetFromBlob(Blob assetBlob, NpmRestoreBlobData data) throws IOException {
        String name;
        NpmRepairComponent npmRepairComponent = (NpmRepairComponent)data.getRepository().facet(NpmRepairComponent.class);
        String string = name = data.getBlobName().startsWith("/") ? data.getBlobName().substring(1) : data.getBlobName();
        if (name.equals(REPOSITORY_ROOT_ASSET)) {
            npmRepairComponent.repairRepositoryRoot(assetBlob, data.getRepository());
        } else if (name.equals(SEARCH_ASSET)) {
            npmRepairComponent.repairSearchIndex(assetBlob, data.getRepository());
        } else {
            String[] nameParts = name.split(TARBALL_ASSET_PATH_PREFIX);
            String npmPackageId = nameParts[0];
            if (nameParts.length == 1) {
                npmRepairComponent.repairPackageRoot(npmPackageId, assetBlob, data.getRepository());
            } else if (nameParts.length == 2) {
                npmRepairComponent.repairTarball(npmPackageId, nameParts[1], assetBlob, data.getRepository());
            }
        }
    }

    protected String getAssetPath(@Nonnull NpmRestoreBlobData data) {
        return data.getBlobName();
    }

    protected NpmRestoreBlobData createRestoreData(Properties properties, Blob blob, BlobStore blobStore) {
        return new NpmRestoreBlobData(blob, properties, blobStore, this.repositoryManager);
    }

    protected boolean isComponentRequired(NpmRestoreBlobData data) {
        return data.getBlobName().contains(TARBALL_ASSET_PATH_PREFIX);
    }

    public void after(boolean updateAssets, Repository repository) {
    }
}

