/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.staging.internal.orient;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.sonatype.nexus.staging.internal.NotFoundStagingException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobAttributes;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.entity.EntityMetadata;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.error.MissingAssetException;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.ComponentDirector;
import org.sonatype.nexus.repository.storage.ComponentMaintenance;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named(value="orient")
@Singleton
public class OrientStagingComponentManager
extends ComponentSupport {
    private BlobStoreManager blobStoreManager;
    private NodeAccess nodeAccess;

    @Inject
    public OrientStagingComponentManager(BlobStoreManager blobStoreManager, NodeAccess nodeAccess) {
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
    }

    protected Component move(ComponentDirector componentDirector, EntityId componentId, Repository source, Repository destination) {
        UnitOfWork.begin((Supplier)((StorageFacet)source.facet(StorageFacet.class)).txSupplier());
        try {
            Map.Entry<Component, List<Asset>> entry = this.getComponentAssets(componentId);
            Component component = entry.getKey();
            List<Asset> assets = entry.getValue();
            this.log.debug("Moving {{}}, from '{}' to '{}'", new Object[]{component.toStringExternal(), source.getName(), destination.getName()});
            component = componentDirector.beforeMove(component, assets, source, destination);
            UnitOfWork paused = UnitOfWork.pause();
            try {
                ((ComponentMaintenance)source.facet(ComponentMaintenance.class)).deleteComponent(this.entityIdOf(component), false);
            }
            finally {
                UnitOfWork.resume((UnitOfWork)paused);
            }
            component = this.doMove(destination, component, assets);
            Component component2 = componentDirector.afterMove(component, destination);
            return component2;
        }
        catch (MissingAssetException ex) {
            throw new NotFoundStagingException(ex.getMessage(), ex.getData());
        }
        finally {
            UnitOfWork.end();
        }
    }

    protected void verifyMove(ComponentDirector componentDirector, EntityId componentId, Repository source, Repository destination) {
        UnitOfWork.begin((Supplier)((StorageFacet)source.facet(StorageFacet.class)).txSupplier());
        try {
            Component component = this.getComponent(componentId);
            if (!componentDirector.allowMoveTo(component, destination)) {
                throw new MoveNotAllowedException("Move not supported for component: " + component.toStringExternal());
            }
            if (this.componentExists(component, destination) && !componentDirector.redeployAllowed(destination, component)) {
                throw new MoveNotAllowedException("Destination already contains component: " + component.toStringExternal());
            }
        }
        finally {
            UnitOfWork.end();
        }
    }

    @Transactional
    protected Map.Entry<Component, List<Asset>> getComponentAssets(EntityId componentId) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        return Optional.of(componentId).map(this::getComponent).map(c -> new AbstractMap.SimpleEntry<Component, ArrayList>((Component)c, Lists.newArrayList((Iterable)tx.browseAssets(c)))).get();
    }

    @Transactional
    protected Component getComponent(EntityId componentId) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        return Optional.of(componentId).map(arg_0 -> ((StorageTx)tx).findComponent(arg_0)).orElseThrow(() -> new ComponentToMoveNotFoundException(componentId));
    }

    @Transactional
    protected boolean componentExists(Component component, Repository repository) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        return tx.componentExists(component.group(), component.name(), component.version(), repository);
    }

    @Transactional
    protected Component doMove(Repository destination, Component component, List<Asset> assets) {
        StorageTx storageTx = (StorageTx)UnitOfWork.currentTx();
        EntityId destBucketId = this.bucketEntityIdOf(storageTx, destination);
        this.log.debug("Moving to destination: {}, component: {}", (Object)destination.getName(), (Object)component.toStringExternal());
        this.findDuplicate(component, destination, storageTx).ifPresent(arg_0 -> ((StorageTx)storageTx).deleteComponent(arg_0));
        component.setEntityMetadata(null);
        component.bucketId(destBucketId);
        storageTx.saveComponent(component);
        EntityId id = this.entityIdOf(component);
        assets.forEach(asset -> {
            BlobRef blobRef = asset.blobRef();
            asset.setEntityMetadata(null);
            asset.bucketId(destBucketId);
            asset.componentId(id);
            asset.blobRef(this.moveBlob(blobRef, destination));
            storageTx.saveAsset(asset);
        });
        return component;
    }

    private Optional<Component> findDuplicate(Component component, Repository repository, StorageTx storageTx) {
        Query.Builder builder = Query.builder().where("name").eq((Object)component.name());
        if (component.version() != null) {
            builder.and("version").eq((Object)component.version());
        }
        if (component.group() != null) {
            builder.and("group").eq((Object)component.group());
        }
        return StreamSupport.stream(storageTx.findComponents(builder.build(), Collections.singletonList(repository)).spliterator(), false).findFirst();
    }

    private EntityId entityIdOf(Component component) {
        return Optional.of(component).map(Entity::getEntityMetadata).map(EntityMetadata::getId).orElseThrow(() -> new IllegalStateException("Unable to obtain entity id for component: " + component.name()));
    }

    private EntityId bucketEntityIdOf(StorageTx storageTx, Repository repository) {
        return Optional.of(storageTx).map(tx -> tx.findBucket(repository)).map(Entity::getEntityMetadata).map(EntityMetadata::getId).orElseThrow(() -> new IllegalStateException("Unable to obtain bucket entity id for repository: " + repository.getConfiguration()));
    }

    private String blobStoreNameOf(Repository repository, String failureMessage) {
        return Optional.of(repository).map(Repository::getConfiguration).map(c -> c.attributes("storage")).map(a -> (String)a.get("blobStoreName", String.class)).orElseThrow(() -> new IllegalStateException(String.format(failureMessage, repository.getName())));
    }

    private BlobStore blobStoreOf(String blobStoreName, String failureMessage) {
        return Optional.of(blobStoreName).map(arg_0 -> ((BlobStoreManager)this.blobStoreManager).get(arg_0)).orElseThrow(() -> new IllegalStateException(String.format(failureMessage, blobStoreName)));
    }

    private InputStream inputStreamOf(BlobStore blobStore, BlobRef blobRef, String failureMessage) {
        return Optional.of(blobRef).map(BlobRef::getBlobId).map(r -> blobStore.get(r, true)).map(Blob::getInputStream).orElseThrow(() -> new IllegalStateException(String.format(failureMessage, blobRef)));
    }

    private BlobRef moveBlob(BlobRef srcBlobRef, Repository destRepo) {
        Preconditions.checkNotNull((Object)srcBlobRef);
        Preconditions.checkNotNull((Object)destRepo);
        String destBlobStoreName = this.blobStoreNameOf(destRepo, "Unable to find blob store name for destination repository: %s");
        String srcBlobStoreName = srcBlobRef.getStore();
        BlobStore srcBlobStore = this.blobStoreOf(srcBlobStoreName, "Unable to find source blob store: %s");
        if (destBlobStoreName.equals(srcBlobStoreName)) {
            BlobAttributes blobAttributes = srcBlobStore.getBlobAttributes(srcBlobRef.getBlobId());
            blobAttributes.setDeleted(false);
            blobAttributes.setDeletedReason(null);
            blobAttributes.getHeaders().put("Bucket.repo-name", destRepo.getName());
            srcBlobStore.setBlobAttributes(srcBlobRef.getBlobId(), blobAttributes);
            return srcBlobRef;
        }
        BlobStore destBlobStore = this.blobStoreOf(destBlobStoreName, "Unable to find destination blob store: %s");
        BlobAttributes blobAttributes = srcBlobStore.getBlobAttributes(srcBlobRef.getBlobId());
        blobAttributes.getHeaders().put("Bucket.repo-name", destRepo.getName());
        InputStream srcInputStream = this.inputStreamOf(srcBlobStore, srcBlobRef, "Unable to get input stream for source blob ref: %s");
        Blob blob = destBlobStore.create(srcInputStream, blobAttributes.getHeaders());
        srcBlobStore.deleteHard(srcBlobRef.getBlobId());
        return new BlobRef(this.nodeAccess.getId(), destBlobStoreName, blob.getId().asUniqueString());
    }

    protected static class ComponentToMoveNotFoundException
    extends RuntimeException {
        ComponentToMoveNotFoundException(EntityId componentId) {
            super("Unable to find component by id: " + componentId);
        }
    }

    protected static class MoveNotAllowedException
    extends RuntimeException {
        MoveNotAllowedException(String message) {
            super(message);
        }
    }
}

