/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.staging.internal.datastore;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.sonatype.nexus.staging.internal.BadRequestStagingException;
import com.sonatype.nexus.staging.internal.NotFoundStagingException;
import com.sonatype.nexus.staging.internal.PermissionStagingException;
import com.sonatype.nexus.staging.internal.StagingService;
import com.sonatype.nexus.staging.internal.datastore.DatastoreStagingComponentManager;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.core.UriInfo;
import org.apache.shiro.authz.Permission;
import org.sonatype.nexus.common.entity.EntityHelper;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.director.ContentDirector;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.maintenance.ContentMaintenanceFacet;
import org.sonatype.nexus.repository.content.store.InternalIds;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.search.ComponentSearchResult;
import org.sonatype.nexus.repository.search.SearchRequest;
import org.sonatype.nexus.repository.search.SearchService;
import org.sonatype.nexus.repository.search.SearchUtils;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.RepositoryViewPermission;
import org.sonatype.nexus.repository.security.VariableResolverAdapter;
import org.sonatype.nexus.repository.security.VariableResolverAdapterManager;
import org.sonatype.nexus.security.SecurityHelper;

@Named(value="mybatis")
@Singleton
public class DatastoreStagingService
extends StateGuardLifecycleSupport
implements StagingService {
    private static final Set<String> SUPPORTED_REPO_TYPES = ImmutableSet.of((Object)"hosted");
    private static final String REPOSITORY = "repository";
    private static final String TYPE = "type";
    private static final String FORMAT = "format";
    private static final String SOURCE = "source";
    private static final String GROUP = "group";
    private static final String NAME = "name";
    private static final String VERSION = "version";
    private static final String ID = "id";
    private static final String N_A = "n/a";
    private static final String DESTINATION = "destination";
    private static final String COMPONENT = "component";
    private static final String COMPONENTS_MOVED = "components moved";
    private static final String COMPONENTS_DELETED = "components deleted";
    private final RepositoryManager repositoryManager;
    private final SearchService searchService;
    private final DatastoreStagingComponentManager componentManager;
    private final Map<String, ContentDirector> contentDirectors;
    private final SearchUtils searchUtils;
    private final SecurityHelper securityHelper;
    private final ContentPermissionChecker permissionsChecker;
    private final VariableResolverAdapterManager variableResolverAdapterManager;

    @Inject
    public DatastoreStagingService(RepositoryManager repositoryManager, SearchService searchService, DatastoreStagingComponentManager componentManager, Map<String, ContentDirector> contentDirectors, SearchUtils searchUtils, SecurityHelper securityHelper, ContentPermissionChecker permissionsChecker, VariableResolverAdapterManager variableResolverAdapterManager) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.searchService = (SearchService)Preconditions.checkNotNull((Object)searchService);
        this.componentManager = (DatastoreStagingComponentManager)((Object)Preconditions.checkNotNull((Object)((Object)componentManager)));
        this.contentDirectors = (Map)Preconditions.checkNotNull(contentDirectors);
        this.searchUtils = (SearchUtils)Preconditions.checkNotNull((Object)searchUtils);
        this.securityHelper = (SecurityHelper)Preconditions.checkNotNull((Object)securityHelper);
        this.permissionsChecker = (ContentPermissionChecker)Preconditions.checkNotNull((Object)permissionsChecker);
        this.variableResolverAdapterManager = (VariableResolverAdapterManager)Preconditions.checkNotNull((Object)variableResolverAdapterManager);
    }

    @Override
    @Guarded(by={"STARTED"})
    public Map<String, Object> move(String destinationRepository, UriInfo uriInfo) {
        this.log.debug("Invoking move: {}", (Object)uriInfo.getAbsolutePath().toString());
        this.log.debug("Query parameters: {}", (Object)uriInfo.getQueryParameters());
        Repository destination = this.validDestinationRepository(destinationRepository);
        this.checkForDestinationRepositoryTypeSupport(destination);
        ContentDirector contentDirector = this.validContentDirector(destination);
        this.checkAllowMoveTo(contentDirector, destination);
        Iterable<ComponentSearchResult> searchHits = this.browse(uriInfo);
        this.checkComponentsFound(destinationRepository, uriInfo, searchHits);
        Map<String, String> hits = StreamSupport.stream(searchHits.spliterator(), false).collect(Collectors.toMap(ComponentSearchResult::getId, ComponentSearchResult::getRepositoryName));
        HashSet sources = Sets.newHashSet(hits.values());
        this.checkMoveFromPermissions(sources, hits);
        this.checkMoveToPermissions(destination, hits);
        this.checkForSourceRepositoryTypeSupport(sources);
        this.checkForCrossFormatMoves(destinationRepository, sources);
        this.checkAllowMoveFrom(contentDirector, sources);
        this.checkAllowMoveTo(hits, destination, contentDirector);
        List<Map<String, String>> moved = this.doMove(hits, destination, contentDirector);
        contentDirector.afterMove(moved, destination);
        return DatastoreStagingService.map(DESTINATION, destinationRepository, COMPONENTS_MOVED, moved);
    }

    @Override
    @Guarded(by={"STARTED"})
    public Map<String, Object> delete(UriInfo uriInfo) {
        Iterable<ComponentSearchResult> searchHits = this.browse(uriInfo);
        if (Iterables.isEmpty(searchHits)) {
            throw new NotFoundStagingException("No components found", (Map<String, ? extends Object>)DatastoreStagingService.map("query parameters", uriInfo.getQueryParameters()));
        }
        Map<String, Map<String, String>> hits = StreamSupport.stream(searchHits.spliterator(), false).collect(Collectors.toMap(ComponentSearchResult::getId, this::hitForDelete));
        this.checkAllowDelete(hits);
        ArrayList<Map<String, String>> deleted = new ArrayList<Map<String, String>>();
        for (Map.Entry<String, Map<String, String>> hit : hits.entrySet()) {
            this.log.debug("Processing search hit for deletion: {}", hit);
            Repository repository = this.getRepository(hit.getValue().get(REPOSITORY));
            ((ContentMaintenanceFacet)repository.facet(ContentMaintenanceFacet.class)).deleteComponent(this.getComponent(repository, hit.getKey()));
            deleted.add(hit.getValue());
        }
        return DatastoreStagingService.map(COMPONENTS_DELETED, deleted);
    }

    private boolean isPermitted(Repository repository, String action) {
        return this.securityHelper.allPermitted(new Permission[]{new RepositoryViewPermission(repository, new String[]{action})});
    }

    private boolean allPermitDelete(Set<String> repositoryNames) {
        return repositoryNames.stream().map(this::getRepository).allMatch(r -> this.isPermitted((Repository)r, "delete"));
    }

    private boolean notPermitted(Repository repository, List<Asset> assets, String action) {
        String format = repository.getFormat().getValue();
        VariableResolverAdapter adapter = this.variableResolverAdapterManager.get(format);
        return assets.stream().anyMatch(a -> !this.permissionsChecker.isPermitted(repository.getName(), format, action, adapter.fromPath(a.path(), repository.getFormat().getValue())));
    }

    private void checkAllowDelete(Map<String, Map<String, String>> hits) {
        hits.entrySet().stream().filter(this::deleteNotPermittedOnSearchHit).map(hit -> new PermissionStagingException("Delete not permitted", (Map)hit.getValue())).findFirst().ifPresent(e -> {
            throw e;
        });
    }

    private boolean deleteNotPermittedOnSearchHit(Map.Entry<String, Map<String, String>> hit) {
        Repository source = this.getRepository(hit.getValue().get(REPOSITORY));
        Component component = this.getComponent(source, hit.getKey());
        Map.Entry<Component, List<Asset>> entry = this.getComponentAssets(source, component);
        return this.notPermitted(source, entry.getValue(), "delete");
    }

    private Repository validDestinationRepository(String destinationRepository) {
        Optional<Repository> destination = this.repositoryFor(destinationRepository);
        if (!destination.isPresent()) {
            throw new BadRequestStagingException("Destination repository not found", (Map<String, ? extends Object>)DatastoreStagingService.map(REPOSITORY, destinationRepository));
        }
        return destination.get();
    }

    private void checkForDestinationRepositoryTypeSupport(Repository destination) {
        if (this.repoTypeNotSupported(destination)) {
            throw new BadRequestStagingException("Destination repository type not supported", (Map<String, ? extends Object>)DatastoreStagingService.map(REPOSITORY, destination.getName(), TYPE, this.repoTypeFor(destination).orElse(N_A)));
        }
    }

    private ContentDirector validContentDirector(Repository destination) {
        return Optional.of(destination).map(Repository::getFormat).map(Format::getValue).map(this.contentDirectors::get).orElseThrow(() -> new BadRequestStagingException("Destination repository format not supported", (Map<String, ? extends Object>)DatastoreStagingService.map(REPOSITORY, destination.getName(), FORMAT, this.formatFor(destination).orElse(N_A))));
    }

    private void checkAllowMoveTo(ContentDirector contentDirector, Repository destination) {
        if (!contentDirector.allowMoveTo(destination)) {
            throw new BadRequestStagingException("Move not supported for destination repository", (Map<String, ? extends Object>)DatastoreStagingService.map(REPOSITORY, destination.getName(), FORMAT, this.formatFor(destination).orElse(N_A)));
        }
    }

    private void checkComponentsFound(String destination, UriInfo uriInfo, Iterable<ComponentSearchResult> searchHits) {
        if (Iterables.isEmpty(searchHits)) {
            throw new NotFoundStagingException("No components found", (Map<String, ? extends Object>)DatastoreStagingService.map(DESTINATION, destination, "query parameters", uriInfo.getQueryParameters()));
        }
    }

    private void checkMoveToPermissions(Repository destination, Map<String, String> hits) {
        if (this.isPermitted(destination, "add")) {
            return;
        }
        for (Map.Entry<String, String> hit : hits.entrySet()) {
            Component component;
            Repository source = this.getRepository(hit.getValue());
            Map.Entry<Component, List<Asset>> entry = this.getComponentAssets(source, component = this.getComponent(source, hit.getKey()));
            if (!this.notPermitted(destination, entry.getValue(), "add")) continue;
            throw new PermissionStagingException("Move to repository not permitted", (Map<String, ? extends Object>)DatastoreStagingService.map(REPOSITORY, destination.getName(), COMPONENT, DatastoreStagingService.mapFor(entry.getKey())));
        }
    }

    private void checkMoveFromPermissions(Set<String> sources, Map<String, String> hits) {
        if (this.allPermitDelete(sources)) {
            return;
        }
        for (Map.Entry<String, String> hit : hits.entrySet()) {
            Component component;
            Map.Entry<Component, List<Asset>> entry;
            Repository source = this.getRepository(hit.getValue());
            if (!this.notPermitted(source, (entry = this.getComponentAssets(source, component = this.getComponent(source, hit.getKey()))).getValue(), "delete")) continue;
            throw new PermissionStagingException("Move from repository not permitted", (Map<String, ? extends Object>)DatastoreStagingService.map(REPOSITORY, source.getName(), COMPONENT, DatastoreStagingService.mapFor(entry.getKey())));
        }
    }

    private Map.Entry<Component, List<Asset>> getComponentAssets(Repository source, Component component) {
        return new AbstractMap.SimpleEntry<Component, List<Asset>>(component, Lists.newArrayList((Iterable)((ContentFacet)source.facet(ContentFacet.class)).components().with(component).assets()));
    }

    private void checkForSourceRepositoryTypeSupport(Set<String> sources) {
        sources.stream().filter(this::repoTypeNotSupported).map(s -> new BadRequestStagingException("Source repository type not supported", (Map<String, ? extends Object>)DatastoreStagingService.map(REPOSITORY, s, TYPE, this.repoTypeFor((String)s).orElse(N_A)))).findFirst().ifPresent(e -> {
            throw e;
        });
    }

    private void checkForCrossFormatMoves(String destination, Set<String> sources) {
        sources.stream().filter(s -> !this.sameFormat((String)s, destination)).map(s -> new BadRequestStagingException("Source and destination repository formats do not match", (Map<String, ? extends Object>)DatastoreStagingService.map(SOURCE, DatastoreStagingService.map(REPOSITORY, s, FORMAT, this.formatFor((String)s).orElse(N_A)), DESTINATION, DatastoreStagingService.map(REPOSITORY, destination, FORMAT, this.formatFor(destination).orElse(N_A))))).findFirst().ifPresent(e -> {
            throw e;
        });
    }

    private void checkAllowMoveFrom(ContentDirector contentDirector, Set<String> sources) {
        sources.stream().map(this::getRepository).filter(r -> !contentDirector.allowMoveFrom(r)).map(r -> new BadRequestStagingException("Move not supported for source repository", (Map<String, ? extends Object>)DatastoreStagingService.map(REPOSITORY, r.getName(), FORMAT, this.formatFor((Repository)r).orElse(N_A)))).findFirst().ifPresent(e -> {
            throw e;
        });
    }

    private void checkAllowMoveTo(Map<String, String> hits, Repository destination, ContentDirector contentDirector) {
        Iterator<Map.Entry<String, String>> hitsIterator = hits.entrySet().iterator();
        while (hitsIterator.hasNext()) {
            Map.Entry<String, String> hit = hitsIterator.next();
            Repository repository = this.getRepository(hit.getValue());
            try {
                EntityId componentId = EntityHelper.id((String)hit.getKey());
                FluentComponent component = this.getComponent(repository, componentId).orElseThrow(() -> new DatastoreStagingComponentManager.ComponentToMoveNotFoundException(componentId));
                this.componentManager.verifyMove(contentDirector, component, destination);
            }
            catch (DatastoreStagingComponentManager.MoveNotAllowedException e) {
                throw new BadRequestStagingException(e.getMessage(), (Map<String, ? extends Object>)DatastoreStagingService.map(SOURCE, DatastoreStagingService.map(REPOSITORY, repository.getName(), FORMAT, repository.getFormat().getValue()), DESTINATION, DatastoreStagingService.map(REPOSITORY, destination.getName(), FORMAT, destination.getFormat().getValue())));
            }
            catch (DatastoreStagingComponentManager.ComponentToMoveNotFoundException e) {
                this.log.warn(e.getMessage());
                hitsIterator.remove();
            }
        }
    }

    private List<Map<String, String>> doMove(Map<String, String> hits, Repository destination, ContentDirector contentDirector) {
        ArrayList<Map<String, String>> moved = new ArrayList<Map<String, String>>();
        for (Map.Entry<String, String> hit : hits.entrySet()) {
            this.log.debug("Processing search hit for move: {}", hit);
            Repository source = this.getRepository(hit.getValue());
            try {
                Component component = this.componentManager.move(contentDirector, this.getComponent(source, hit.getKey()), source, destination);
                moved.add(this.mapWithIdFor(component));
            }
            catch (DatastoreStagingComponentManager.ComponentToMoveNotFoundException e) {
                this.log.warn(e.getMessage());
            }
        }
        return moved;
    }

    private Map<String, String> hitForDelete(ComponentSearchResult hit) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        DatastoreStagingService.maybePut((ImmutableMap.Builder<String, String>)builder, hit, ComponentSearchResult::getRepositoryName, REPOSITORY);
        DatastoreStagingService.maybePut((ImmutableMap.Builder<String, String>)builder, hit, ComponentSearchResult::getGroup, GROUP);
        DatastoreStagingService.maybePut((ImmutableMap.Builder<String, String>)builder, hit, ComponentSearchResult::getName, NAME);
        DatastoreStagingService.maybePut((ImmutableMap.Builder<String, String>)builder, hit, ComponentSearchResult::getVersion, VERSION);
        return builder.build();
    }

    private static <K, V> ImmutableMap<K, V> map(K k, V v) {
        return ImmutableMap.of(k, v);
    }

    private static <K, V> ImmutableMap<K, V> map(K k1, V v1, K k2, V v2) {
        return ImmutableMap.of(k1, v1, k2, v2);
    }

    private Repository getRepository(String repository) {
        return this.repositoryManager.get(repository);
    }

    private Component getComponent(Repository repository, String componentId) {
        return ((ContentFacet)repository.facet(ContentFacet.class)).components().find(EntityHelper.id((String)componentId)).orElse(null);
    }

    private Optional<FluentComponent> getComponent(Repository repository, EntityId componentId) {
        return ((ContentFacet)repository.facet(ContentFacet.class)).components().find(componentId);
    }

    private boolean repoTypeNotSupported(String repository) {
        return this.repoTypeNotSupported(this.repositoryFor(repository));
    }

    private boolean repoTypeNotSupported(Repository repository) {
        return this.repoTypeNotSupported(Optional.of(repository));
    }

    private boolean repoTypeNotSupported(Optional<Repository> repository) {
        return this.repoTypeFor(repository).map(SUPPORTED_REPO_TYPES::contains).map(b -> b == false).orElse(Boolean.TRUE);
    }

    private boolean sameFormat(String srcRepoName, String dstRepoName) {
        Optional<String> srcFormat = this.formatFor(srcRepoName);
        Optional<String> dstFormat = this.formatFor(dstRepoName);
        return srcFormat.isPresent() && dstFormat.isPresent() && srcFormat.get().equals(dstFormat.get());
    }

    private Optional<Repository> repositoryFor(String repositoryName) {
        return Optional.of(this.repositoryManager).map(rm -> rm.get(repositoryName));
    }

    private Optional<String> formatFor(String repositoryName) {
        return this.formatFor(this.repositoryFor(repositoryName));
    }

    private Iterable<ComponentSearchResult> browse(UriInfo uriInfo) {
        SearchRequest request = SearchRequest.builder().searchFilters((Collection)this.searchUtils.getSearchFilters(uriInfo)).build();
        return this.searchService.browse(request);
    }

    private Optional<String> formatFor(Repository repository) {
        return this.formatFor(Optional.of(repository));
    }

    private Optional<String> formatFor(Optional<Repository> repository) {
        return repository.map(Repository::getFormat).map(Format::getValue);
    }

    private Optional<String> repoTypeFor(String repositoryName) {
        return this.repoTypeFor(this.repositoryFor(repositoryName));
    }

    private Optional<String> repoTypeFor(Repository repository) {
        return this.repoTypeFor(Optional.of(repository));
    }

    private Optional<String> repoTypeFor(Optional<Repository> repository) {
        return repository.map(Repository::getType).map(Type::getValue);
    }

    static Map<String, String> mapFor(Component component) {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)NAME, (Object)component.name());
        DatastoreStagingService.maybePut((ImmutableMap.Builder<String, String>)builder, component, Component::namespace, GROUP);
        DatastoreStagingService.maybePut((ImmutableMap.Builder<String, String>)builder, component, Component::version, VERSION);
        return builder.build();
    }

    static <T> void maybePut(ImmutableMap.Builder<String, String> builder, T t, Function<T, String> f, String key) {
        Optional.of(t).map(f).ifPresent(v -> {
            ImmutableMap.Builder builder2 = builder.put((Object)key, v);
        });
    }

    private Map<String, String> mapWithIdFor(Component component) {
        HashMap<String, String> map = new HashMap<String, String>(DatastoreStagingService.mapFor(component));
        String componentId = this.getComponentId(component);
        map.put(ID, componentId);
        return map;
    }

    private String getComponentId(Component component) {
        return String.valueOf(InternalIds.internalComponentId((Component)component));
    }
}

