/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.staging.internal.datastore;

import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import com.sonatype.nexus.staging.internal.NotFoundStagingException;
import com.sonatype.nexus.tags.TagStore;
import com.sonatype.nexus.tags.datastore.ComponentTag;
import com.sonatype.nexus.tags.datastore.ComponentTagStore;
import com.sonatype.nexus.tags.datastore.ComponentTagStoreManager;
import com.sonatype.nexus.tags.service.TagService;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.time.UTC;
import org.sonatype.nexus.repository.BadRequestException;
import org.sonatype.nexus.repository.MissingBlobException;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.director.ContentDirector;
import org.sonatype.nexus.repository.content.error.MissingAssetException;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentAssetBuilder;
import org.sonatype.nexus.repository.content.fluent.FluentBlobs;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.maintenance.ContentMaintenanceFacet;
import org.sonatype.nexus.repository.content.store.InternalIds;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

@Named(value="mybatis")
@Singleton
public class DatastoreStagingComponentManager
extends ComponentSupport {
    private final BlobStoreManager blobStoreManager;
    private final ComponentTagStoreManager componentTagStoreManager;
    private final int tagLimit;
    private final TagService tagService;
    private final TagStore tagStore;

    @Inject
    public DatastoreStagingComponentManager(BlobStoreManager blobStoreManager, ComponentTagStoreManager componentTagStoreManager, @Named(value="${nexus.export.browseTagsLimit:-1000}") @Named(value="${nexus.export.browseTagsLimit:-1000}") int tagLimit, TagService tagService, TagStore tagStore) {
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
        this.componentTagStoreManager = (ComponentTagStoreManager)Preconditions.checkNotNull((Object)componentTagStoreManager);
        this.tagLimit = (Integer)Preconditions.checkNotNull((Object)tagLimit);
        this.tagService = (TagService)Preconditions.checkNotNull((Object)tagService);
        this.tagStore = (TagStore)Preconditions.checkNotNull((Object)tagStore);
    }

    protected Component move(ContentDirector contentDirector, Component originalComponent, Repository source, Repository destination) {
        try {
            Map.Entry<Component, List<Asset>> entry = this.getComponentAssets(source, originalComponent);
            this.log.debug("Moving {{}}, from '{}' to '{}'", new Object[]{entry.getKey().toStringExternal(), source.getName(), destination.getName()});
            List<Asset> assets = entry.getValue();
            Component component = contentDirector.beforeMove(originalComponent, assets, source, destination);
            ComponentTagStore storeForRepository = this.componentTagStoreManager.getStoreForRepository(source);
            Continuation componentTags = storeForRepository.browseComponentTags(component, this.tagLimit, null);
            List tags = this.tagStore.getByIds(componentTags.stream().map(ComponentTag::getTagId).collect(Collectors.toSet()));
            Component newComponent = this.doMove(contentDirector, destination, component, assets);
            ((ContentMaintenanceFacet)source.facet(ContentMaintenanceFacet.class)).deleteComponent(component);
            tags.forEach(tag -> {
                List list = this.tagService.associateById(tag.name(), destination, InternalIds.toExternalId((int)InternalIds.internalComponentId((Component)newComponent)));
            });
            tags.forEach(tag -> storeForRepository.deleteComponentTag(component, tag));
            return contentDirector.afterMove(newComponent, destination);
        }
        catch (MissingAssetException ex) {
            throw new NotFoundStagingException(ex.getMessage(), ex.getData());
        }
    }

    protected void verifyMove(ContentDirector contentDirector, FluentComponent component, Repository destination) {
        if (!contentDirector.allowMoveTo(component, destination)) {
            throw new MoveNotAllowedException("Move not supported for component: " + component);
        }
        if (this.componentExists((Component)component, destination) && !contentDirector.redeployAllowed(destination, (Component)component)) {
            throw new MoveNotAllowedException("Destination already contains component: " + component);
        }
    }

    protected Map.Entry<Component, List<Asset>> getComponentAssets(Repository repository, Component component) {
        ContentFacet content = (ContentFacet)repository.facet(ContentFacet.class);
        return Optional.of(component).map(c -> new AbstractMap.SimpleEntry((Component)c, new ArrayList(content.components().with(c).assets()))).orElse(null);
    }

    protected boolean componentExists(Component component, Repository repository) {
        return ((ContentFacet)repository.facet(ContentFacet.class)).components().name(component.name()).namespace(component.namespace()).version(component.version()).find().isPresent();
    }

    protected Component doMove(ContentDirector contentDirector, Repository destination, Component source, List<Asset> assets) {
        FluentComponent destComponent = contentDirector.copyComponent(source, destination);
        this.moveAssets(destination, assets, destComponent);
        return destComponent;
    }

    private void moveAssets(Repository destination, List<Asset> assets, FluentComponent destComponent) {
        ContentFacet content = (ContentFacet)destination.facet(ContentFacet.class);
        FluentBlobs blobs = content.blobs();
        assets.stream().filter(Asset::hasBlob).forEach(asset -> {
            FluentAssetBuilder destAssetBuilder = content.assets().path(asset.path()).kind(asset.kind()).component((Component)destComponent);
            asset.attributes().forEach(attribute -> {
                FluentAssetBuilder fluentAssetBuilder2 = destAssetBuilder.attributes((String)attribute.getKey(), attribute.getValue());
            });
            AssetBlob assetBlob = (AssetBlob)asset.blob().get();
            BlobRef blobRef = assetBlob.blobRef();
            String blobStoreName = blobRef.getStore();
            BlobStore sourceBlobStore = this.blobStoreManager.get(blobStoreName);
            if (sourceBlobStore == null) {
                throw new BadRequestException("Blob store not found: " + blobStoreName);
            }
            Blob sourceBlob = sourceBlobStore.get(blobRef.getBlobId());
            if (sourceBlob == null) {
                throw new MissingBlobException(blobRef);
            }
            Map<HashAlgorithm, HashCode> hashes = DatastoreStagingComponentManager.hashes(assetBlob);
            Throwable throwable = null;
            Object var15_15 = null;
            try (TempBlob tempBlob = blobs.ingest(sourceBlob, sourceBlobStore, hashes);){
                FluentAsset destAsset = destAssetBuilder.blob(tempBlob).save();
                destAsset.blobCreated(assetBlob.blobCreated());
                destAsset.blobAddedToRepository(UTC.now());
                this.log.debug("Moved asset {} to repository {}", (Object)destAsset.path(), (Object)destination.getName());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        });
    }

    private static Map<HashAlgorithm, HashCode> hashes(AssetBlob assetBlob) {
        return assetBlob.checksums().entrySet().stream().map(entry -> {
            Optional hashAlgorithm = HashAlgorithm.getHashAlgorithm((String)((String)entry.getKey()));
            return hashAlgorithm.map(algorithm -> new AbstractMap.SimpleEntry<HashAlgorithm, HashCode>((HashAlgorithm)algorithm, HashCode.fromString((String)((String)entry.getValue())))).orElse(null);
        }).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    static class ComponentToMoveNotFoundException
    extends RuntimeException {
        ComponentToMoveNotFoundException(EntityId componentId) {
            super("Unable to find component by id: " + componentId);
        }
    }

    static class MoveNotAllowedException
    extends RuntimeException {
        MoveNotAllowedException(String message) {
            super(message);
        }
    }
}

