/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.expression;

import org.apache.commons.codec.binary.Hex;
import org.odata4j.expression.AddExpression;
import org.odata4j.expression.AggregateAllFunction;
import org.odata4j.expression.AggregateAnyFunction;
import org.odata4j.expression.AndExpression;
import org.odata4j.expression.BinaryLiteral;
import org.odata4j.expression.BoolParenExpression;
import org.odata4j.expression.BooleanLiteral;
import org.odata4j.expression.ByteLiteral;
import org.odata4j.expression.CastExpression;
import org.odata4j.expression.CeilingMethodCallExpression;
import org.odata4j.expression.CommonExpression;
import org.odata4j.expression.ConcatMethodCallExpression;
import org.odata4j.expression.DateTimeLiteral;
import org.odata4j.expression.DateTimeOffsetLiteral;
import org.odata4j.expression.DayMethodCallExpression;
import org.odata4j.expression.DecimalLiteral;
import org.odata4j.expression.DivExpression;
import org.odata4j.expression.DoubleLiteral;
import org.odata4j.expression.EndsWithMethodCallExpression;
import org.odata4j.expression.EntitySimpleProperty;
import org.odata4j.expression.EqExpression;
import org.odata4j.expression.ExpressionParser;
import org.odata4j.expression.ExpressionVisitor;
import org.odata4j.expression.FloorMethodCallExpression;
import org.odata4j.expression.GeExpression;
import org.odata4j.expression.GtExpression;
import org.odata4j.expression.GuidLiteral;
import org.odata4j.expression.HourMethodCallExpression;
import org.odata4j.expression.IndexOfMethodCallExpression;
import org.odata4j.expression.Int64Literal;
import org.odata4j.expression.IntegralLiteral;
import org.odata4j.expression.IsofExpression;
import org.odata4j.expression.LeExpression;
import org.odata4j.expression.LengthMethodCallExpression;
import org.odata4j.expression.LtExpression;
import org.odata4j.expression.MinuteMethodCallExpression;
import org.odata4j.expression.ModExpression;
import org.odata4j.expression.MonthMethodCallExpression;
import org.odata4j.expression.MulExpression;
import org.odata4j.expression.NeExpression;
import org.odata4j.expression.NegateExpression;
import org.odata4j.expression.NotExpression;
import org.odata4j.expression.NullLiteral;
import org.odata4j.expression.OrExpression;
import org.odata4j.expression.OrderByExpression;
import org.odata4j.expression.ParenExpression;
import org.odata4j.expression.ReplaceMethodCallExpression;
import org.odata4j.expression.RoundMethodCallExpression;
import org.odata4j.expression.SByteLiteral;
import org.odata4j.expression.SecondMethodCallExpression;
import org.odata4j.expression.SingleLiteral;
import org.odata4j.expression.StartsWithMethodCallExpression;
import org.odata4j.expression.StringLiteral;
import org.odata4j.expression.SubExpression;
import org.odata4j.expression.SubstringMethodCallExpression;
import org.odata4j.expression.SubstringOfMethodCallExpression;
import org.odata4j.expression.TimeLiteral;
import org.odata4j.expression.ToLowerMethodCallExpression;
import org.odata4j.expression.ToUpperMethodCallExpression;
import org.odata4j.expression.TrimMethodCallExpression;
import org.odata4j.expression.YearMethodCallExpression;
import org.odata4j.internal.InternalUtil;

public class PrintExpressionVisitor
implements ExpressionVisitor {
    private final StringBuilder sb = new StringBuilder();

    public static String asString(CommonExpression expr) {
        PrintExpressionVisitor v = new PrintExpressionVisitor();
        expr.visit(v);
        return v.toString();
    }

    public String toString() {
        return this.sb.toString();
    }

    private void append(String value) {
        this.sb.append(value);
    }

    private void append(String format, Object ... args) {
        this.sb.append(String.format(format, args));
    }

    @Override
    public void visit(String type) {
        this.append(type);
    }

    @Override
    public void afterDescend() {
        this.append(")");
    }

    @Override
    public void beforeDescend() {
        this.append("(");
    }

    @Override
    public void betweenDescend() {
        this.append(",");
    }

    @Override
    public void visit(AddExpression expr) {
        this.append("add");
    }

    @Override
    public void visit(AndExpression expr) {
        this.append("and");
    }

    @Override
    public void visit(BooleanLiteral expr) {
        this.append("boolean(%s)", expr.getValue());
    }

    @Override
    public void visit(CastExpression expr) {
        this.append("cast");
    }

    @Override
    public void visit(ConcatMethodCallExpression expr) {
        this.append("concat");
    }

    @Override
    public void visit(DateTimeLiteral expr) {
        this.append("datetime(%s)", InternalUtil.formatDateTimeForXml(expr.getValue()));
    }

    @Override
    public void visit(DateTimeOffsetLiteral expr) {
        this.append("datetime(%s)", InternalUtil.formatDateTimeOffsetForXml(expr.getValue()));
    }

    @Override
    public void visit(DecimalLiteral expr) {
        this.append("decimal(%s)", expr.getValue());
    }

    @Override
    public void visit(DivExpression expr) {
        this.append("div");
    }

    @Override
    public void visit(EndsWithMethodCallExpression expr) {
        this.append("endswith");
    }

    @Override
    public void visit(EntitySimpleProperty expr) {
        this.append("simpleProperty(%s)", expr.getPropertyName());
    }

    @Override
    public void visit(EqExpression expr) {
        this.append("eq");
    }

    @Override
    public void visit(GeExpression expr) {
        this.append("ge");
    }

    @Override
    public void visit(GtExpression expr) {
        this.append("gt");
    }

    @Override
    public void visit(GuidLiteral expr) {
        this.append("guid(%s)", expr.getValue());
    }

    @Override
    public void visit(IndexOfMethodCallExpression expr) {
        this.append("indexof");
    }

    @Override
    public void visit(IntegralLiteral expr) {
        this.append("integral(%s)", expr.getValue());
    }

    @Override
    public void visit(IsofExpression expr) {
        this.append("isof");
    }

    @Override
    public void visit(LeExpression expr) {
        this.append("le");
    }

    @Override
    public void visit(LengthMethodCallExpression expr) {
        this.append("length");
    }

    @Override
    public void visit(LtExpression expr) {
        this.append("lt");
    }

    @Override
    public void visit(ModExpression expr) {
        this.append("mod");
    }

    @Override
    public void visit(MulExpression expr) {
        this.append("mul");
    }

    @Override
    public void visit(NeExpression expr) {
        this.append("ne");
    }

    @Override
    public void visit(NegateExpression expr) {
        this.append("negate");
    }

    @Override
    public void visit(NotExpression expr) {
        this.append("not");
    }

    @Override
    public void visit(NullLiteral expr) {
        this.append("null");
    }

    @Override
    public void visit(OrExpression expr) {
        this.append("or");
    }

    @Override
    public void visit(ParenExpression expr) {
        this.append("paren");
    }

    @Override
    public void visit(BoolParenExpression expr) {
        this.append("boolParen");
    }

    @Override
    public void visit(ReplaceMethodCallExpression expr) {
        this.append("replace");
    }

    @Override
    public void visit(StartsWithMethodCallExpression expr) {
        this.append("startswith");
    }

    @Override
    public void visit(StringLiteral expr) {
        this.append("string(%s)", expr.getValue());
    }

    @Override
    public void visit(SubExpression expr) {
        this.append("sub");
    }

    @Override
    public void visit(SubstringMethodCallExpression expr) {
        this.append("substring");
    }

    @Override
    public void visit(SubstringOfMethodCallExpression expr) {
        this.append("substringof");
    }

    @Override
    public void visit(TimeLiteral expr) {
        this.append("time(%s)", expr.getValue().toString(ExpressionParser.TIME_FORMATTER));
    }

    @Override
    public void visit(ToLowerMethodCallExpression expr) {
        this.append("tolower");
    }

    @Override
    public void visit(ToUpperMethodCallExpression expr) {
        this.append("toupper");
    }

    @Override
    public void visit(TrimMethodCallExpression expr) {
        this.append("trim");
    }

    @Override
    public void visit(YearMethodCallExpression expr) {
        this.append("year");
    }

    @Override
    public void visit(MonthMethodCallExpression expr) {
        this.append("month");
    }

    @Override
    public void visit(DayMethodCallExpression expr) {
        this.append("day");
    }

    @Override
    public void visit(HourMethodCallExpression expr) {
        this.append("hour");
    }

    @Override
    public void visit(MinuteMethodCallExpression expr) {
        this.append("minute");
    }

    @Override
    public void visit(SecondMethodCallExpression expr) {
        this.append("second");
    }

    @Override
    public void visit(RoundMethodCallExpression expr) {
        this.append("round");
    }

    @Override
    public void visit(FloorMethodCallExpression expr) {
        this.append("floor");
    }

    @Override
    public void visit(CeilingMethodCallExpression expr) {
        this.append("ceiling");
    }

    @Override
    public void visit(OrderByExpression expr) {
        this.append("orderBy");
    }

    @Override
    public void visit(OrderByExpression.Direction direction) {
        this.append(direction == OrderByExpression.Direction.ASCENDING ? "asc" : "desc");
    }

    @Override
    public void visit(Int64Literal expr) {
        this.append("int64(%s)", expr.getValue());
    }

    @Override
    public void visit(SingleLiteral expr) {
        this.append("single(%s)", Float.valueOf(expr.getValue()));
    }

    @Override
    public void visit(DoubleLiteral expr) {
        this.append("double(%s)", expr.getValue());
    }

    @Override
    public void visit(BinaryLiteral expr) {
        this.append("binary(%s)", Hex.encodeHexString((byte[])expr.getValue()));
    }

    @Override
    public void visit(ByteLiteral expr) {
        this.append("byte(%s)", expr.getValue());
    }

    @Override
    public void visit(SByteLiteral expr) {
        this.append("sbyte(%s)", expr.getValue());
    }

    @Override
    public void visit(AggregateAnyFunction expr) {
        if (expr.getVariable() != null) {
            this.append("any:(%s =>)", expr.getVariable());
        } else {
            this.append("any()");
        }
    }

    @Override
    public void visit(AggregateAllFunction expr) {
        this.append("all:%s =>", expr.getVariable());
    }
}

