/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.rest;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.blobstore.ConnectionChecker;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.blobstore.api.BlobStoreConnectionException;
import org.sonatype.nexus.blobstore.api.BlobStoreException;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.blobstore.quota.BlobStoreQuotaResult;
import org.sonatype.nexus.blobstore.quota.BlobStoreQuotaService;
import org.sonatype.nexus.blobstore.rest.BlobStoreConnectionXO;
import org.sonatype.nexus.blobstore.rest.BlobStoreQuotaResultXO;
import org.sonatype.nexus.blobstore.rest.BlobStoreResourceDoc;
import org.sonatype.nexus.blobstore.rest.BlobStoreResourceUtil;
import org.sonatype.nexus.blobstore.rest.GenericBlobStoreApiResponse;
import org.sonatype.nexus.repository.blobstore.BlobStoreConfigurationStore;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.validation.Validate;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class BlobStoreResource
extends ComponentSupport
implements Resource,
BlobStoreResourceDoc {
    private final BlobStoreManager blobStoreManager;
    private final BlobStoreConfigurationStore store;
    private final BlobStoreQuotaService quotaService;
    private final Map<String, ConnectionChecker> connectionCheckers;
    private static final Messages messages = (Messages)I18N.create(Messages.class);

    public BlobStoreResource(BlobStoreManager blobStoreManager, BlobStoreConfigurationStore store, BlobStoreQuotaService quotaService, Map<String, ConnectionChecker> connectionCheckers) {
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
        this.store = (BlobStoreConfigurationStore)Preconditions.checkNotNull((Object)store);
        this.quotaService = (BlobStoreQuotaService)Preconditions.checkNotNull((Object)quotaService);
        this.connectionCheckers = connectionCheckers;
    }

    @Override
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:blobstores:read"})
    @GET
    public List<GenericBlobStoreApiResponse> listBlobStores() {
        Map blobstoresByName = this.blobStoreManager.getByName();
        return this.store.list().stream().map(configuration -> new GenericBlobStoreApiResponse((BlobStoreConfiguration)configuration, (BlobStore)blobstoresByName.get(configuration.getName()))).collect(Collectors.toList());
    }

    @Override
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:blobstores:delete"})
    @DELETE
    @Path(value="/{name}")
    public void deleteBlobStore(@PathParam(value="name") String name) throws Exception {
        if (!this.blobStoreManager.exists(name)) {
            BlobStoreResourceUtil.throwCreateBlobStoreNotFoundException("", name);
        }
        try {
            this.blobStoreManager.delete(name);
        }
        catch (BlobStoreException e) {
            BlobStoreResourceUtil.throwBlobStoreBadRequestException(e.getMessage());
        }
    }

    @Override
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:blobstores:read"})
    @GET
    @Path(value="/{name}/quota-status")
    public BlobStoreQuotaResultXO quotaStatus(@PathParam(value="name") String name) {
        BlobStore blobStore = this.blobStoreManager.get(name);
        if (blobStore == null) {
            throw new WebApplicationException(String.format("No blob store found for id '%s' ", name), Response.Status.NOT_FOUND);
        }
        BlobStoreQuotaResult result = this.quotaService.checkQuota(blobStore);
        return result != null ? BlobStoreQuotaResultXO.asQuotaXO(result) : BlobStoreQuotaResultXO.asNoQuotaXO(name);
    }

    @Override
    @POST
    @Path(value="test-connection")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:blobstores:read"})
    @Validate
    public void verifyConnection(@NotNull @Valid BlobStoreConnectionXO blobStoreConnectionXO) {
        try {
            ConnectionChecker conChecker = (ConnectionChecker)Preconditions.checkNotNull((Object)this.connectionCheckers.get(blobStoreConnectionXO.getType()));
            conChecker.verifyConnection(blobStoreConnectionXO.getName(), blobStoreConnectionXO.getAttributes());
        }
        catch (BlobStoreConnectionException ce) {
            this.log.error("Can't connect to {} blob store", (Object)blobStoreConnectionXO.getType(), (Object)ce);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ce.getMessage()).build());
        }
        catch (Exception e) {
            this.log.warn("Can't connect to {} blob store", (Object)blobStoreConnectionXO.getType(), (Object)e);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)messages.connectionError()).build());
        }
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Connection failed, check the logs for more information.")
        public String connectionError();
    }
}

