/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.quota.internal;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.blobstore.quota.BlobStoreQuota;
import org.sonatype.nexus.blobstore.quota.BlobStoreQuotaResult;
import org.sonatype.nexus.blobstore.quota.BlobStoreQuotaService;
import org.sonatype.nexus.rest.ValidationErrorsException;

@Named
@Singleton
public class BlobStoreQuotaServiceImpl
extends ComponentSupport
implements BlobStoreQuotaService {
    private final Map<String, BlobStoreQuota> quotas;

    @Inject
    public BlobStoreQuotaServiceImpl(Map<String, BlobStoreQuota> quotas) {
        this.quotas = (Map)Preconditions.checkNotNull(quotas);
    }

    @Override
    public void validateSoftQuotaConfig(BlobStoreConfiguration config) {
        this.getQuotaType(config).ifPresent(type -> {
            if (!this.quotas.containsKey(type)) {
                throw new ValidationErrorsException("To enable Soft Quota, you must select a Type of Quota");
            }
        });
        this.getQuota(config).ifPresent(quota -> quota.validateConfig(config));
    }

    private Optional<String> getQuotaType(BlobStoreConfiguration config) {
        return Optional.ofNullable((String)config.attributes("blobStoreQuotaConfig").get("quotaType", String.class));
    }

    private Optional<BlobStoreQuota> getQuota(BlobStoreConfiguration config) {
        Optional<String> quotaType = this.getQuotaType(config);
        Optional<BlobStoreQuota> quota = quotaType.map(this.quotas::get);
        if (quotaType.isPresent() && !quota.isPresent()) {
            this.log.error("For blob store {} unable to find quota type for key {}", (Object)config.getName(), (Object)quotaType.get());
        }
        return quota;
    }

    @Override
    @Nullable
    public BlobStoreQuotaResult checkQuota(BlobStore blobStore) {
        Preconditions.checkNotNull((Object)blobStore);
        BlobStoreConfiguration config = blobStore.getBlobStoreConfiguration();
        return this.getQuota(config).map(quota -> {
            this.log.debug("Checking blob store {} for quota {}", (Object)config.getName(), quota);
            return quota.check(blobStore);
        }).orElse(null);
    }
}

