/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.quota;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.quota.BlobStoreQuotaService;
import org.sonatype.nexus.blobstore.quota.BlobStoreQuotaSupport;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.scheduling.PeriodicJobService;

@Named
public class BlobStoreQuotaUsageChecker
extends StateGuardLifecycleSupport {
    protected final PeriodicJobService jobService;
    protected final int quotaCheckInterval;
    protected final BlobStoreQuotaService quotaService;
    protected BlobStore blobStore;
    protected PeriodicJobService.PeriodicJob quotaCheckingJob;

    @Inject
    public BlobStoreQuotaUsageChecker(PeriodicJobService jobService, @Named(value="${nexus.blobstore.quota.warnIntervalSeconds:-60}") @Named(value="${nexus.blobstore.quota.warnIntervalSeconds:-60}") int quotaCheckInterval, BlobStoreQuotaService quotaService) {
        this.jobService = (PeriodicJobService)Preconditions.checkNotNull((Object)jobService);
        Preconditions.checkArgument((quotaCheckInterval > 0 ? 1 : 0) != 0);
        this.quotaCheckInterval = quotaCheckInterval;
        this.quotaService = (BlobStoreQuotaService)Preconditions.checkNotNull((Object)quotaService);
    }

    protected void doStart() throws Exception {
        this.jobService.startUsing();
        this.quotaCheckingJob = this.jobService.schedule(BlobStoreQuotaSupport.createQuotaCheckJob(this.blobStore, this.quotaService, this.log), this.quotaCheckInterval);
    }

    protected void doStop() throws Exception {
        this.blobStore = null;
        this.quotaCheckingJob.cancel();
        this.quotaCheckingJob = null;
        this.jobService.stopUsing();
    }

    public void setBlobStore(BlobStore blobStore) {
        Preconditions.checkState((this.blobStore == null ? 1 : 0) != 0, (Object)"Do not initialize twice");
        Preconditions.checkNotNull((Object)blobStore);
        this.blobStore = blobStore;
    }
}

