/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.group.internal;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.group.BlobStoreGroup;
import org.sonatype.nexus.blobstore.group.FillPolicy;
import org.sonatype.nexus.blobstore.quota.BlobStoreQuotaResult;
import org.sonatype.nexus.blobstore.quota.BlobStoreQuotaService;

@Named(value="roundRobin")
public class RoundRobinFillPolicy
extends ComponentSupport
implements FillPolicy {
    public static final String TYPE = "roundRobin";
    protected static final String NAME = "Round Robin";
    private AtomicInteger sequence = new AtomicInteger();
    @Inject
    private BlobStoreQuotaService quotaService;
    @Inject
    @Named(value="${nexus.blobstore.skipOnSoftQuotaViolation:-false}")
    boolean skipOnSoftQuotaViolation;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    @Nullable
    public BlobStore chooseBlobStore(BlobStoreGroup blobStoreGroup, Map<String, String> headers) {
        return this.nextMember(blobStoreGroup.getMembers());
    }

    @Nullable
    private BlobStore nextMember(List<BlobStore> members) {
        if (members.isEmpty()) {
            return null;
        }
        int index = this.nextIndex() % members.size();
        this.log.trace("Using index {}", (Object)index);
        ArrayList<BlobStore> rotatedMembers = new ArrayList<BlobStore>(members);
        Collections.rotate(rotatedMembers, index);
        return rotatedMembers.stream().filter(BlobStore::isWritable).filter(BlobStore::isStorageAvailable).filter(this.skipOnSoftQuotaViolation ? this::hasNoQuotaViolation : s -> true).findFirst().orElse(null);
    }

    @VisibleForTesting
    int nextIndex() {
        return this.sequence.getAndUpdate(i -> ++i < 0 ? 0 : i);
    }

    private boolean hasNoQuotaViolation(BlobStore blobStore) {
        BlobStoreQuotaResult result = this.quotaService.checkQuota(blobStore);
        if (result != null && result.isViolation()) {
            if (this.log.isTraceEnabled()) {
                this.log.info("Skipping blobStore {} due to soft-quota violation: {}", (Object)result.getBlobStoreName(), (Object)result.getMessage());
            } else {
                this.log.info("Skipping blobStore {} due to soft-quota violation", (Object)result.getBlobStoreName());
            }
            return false;
        }
        return true;
    }
}

