/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.group.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Streams;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.commons.lang.StringUtils;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.blobstore.BlobStoreDescriptorSupport;
import org.sonatype.nexus.blobstore.BlobStoreUtil;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.blobstore.group.BlobStoreGroupConfigurationHelper;
import org.sonatype.nexus.blobstore.group.BlobStoreGroupService;
import org.sonatype.nexus.blobstore.group.FillPolicy;
import org.sonatype.nexus.blobstore.quota.BlobStoreQuotaService;
import org.sonatype.nexus.common.upgrade.AvailabilityVersion;
import org.sonatype.nexus.formfields.ComboboxFormField;
import org.sonatype.nexus.formfields.FormField;
import org.sonatype.nexus.formfields.ItemselectFormField;
import org.sonatype.nexus.rest.ValidationErrorsException;

@AvailabilityVersion(from="1.0")
@Named(value="Group")
public class BlobStoreGroupDescriptor
extends BlobStoreDescriptorSupport {
    private static final Messages messages = (Messages)I18N.create(Messages.class);
    private final BlobStoreManager blobStoreManager;
    private final BlobStoreUtil blobStoreUtil;
    private final Provider<BlobStoreGroupService> blobStoreGroupService;
    private final ItemselectFormField members;
    private final FormField fillPolicy;
    private final Map<String, FillPolicy> fillPolicies;

    @Inject
    public BlobStoreGroupDescriptor(BlobStoreManager blobStoreManager, BlobStoreUtil blobStoreUtil, Provider<BlobStoreGroupService> blobStoreGroupService, BlobStoreQuotaService quotaService, Map<String, FillPolicy> fillPolicies) {
        super(quotaService);
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
        this.blobStoreUtil = (BlobStoreUtil)Preconditions.checkNotNull((Object)blobStoreUtil);
        this.blobStoreGroupService = (Provider)Preconditions.checkNotNull(blobStoreGroupService);
        this.fillPolicies = (Map)Preconditions.checkNotNull(fillPolicies);
        this.members = new ItemselectFormField("members", messages.membersLabel(), null, true);
        this.members.setStoreApi("coreui_Blobstore.readGroupable");
        this.members.setIdMapping("name");
        this.members.setButtons(new String[]{"up", "add", "remove", "down"});
        this.members.setFromTitle("Available Blob Stores");
        this.members.setToTitle("Selected Blob Stores");
        this.fillPolicy = new ComboboxFormField("fillPolicy", messages.fillPolicyLabel(), null, true).withStoreApi("coreui_Blobstore.fillPolicies");
        this.fillPolicy.getAttributes().put("options", fillPolicies.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((FillPolicy)e.getValue()).getName())));
    }

    @Override
    public String getId() {
        return "group";
    }

    @Override
    public String getName() {
        return messages.name();
    }

    @Override
    public List<FormField> getFormFields() {
        List blobStores = Streams.stream((Iterable)this.blobStoreManager.browse()).map(BlobStore::getBlobStoreConfiguration).map(BlobStoreConfiguration::getName).collect(Collectors.toList());
        this.members.getAttributes().put("options", blobStores);
        return Arrays.asList(this.members, this.fillPolicy);
    }

    @Override
    public boolean isModifiable() {
        return this.isEnabled();
    }

    @Override
    public void validateConfig(BlobStoreConfiguration config) {
        super.validateConfig(config);
        this.validateEnabled();
        String name = config.getName();
        String fillPolicy = (String)config.attributes("group").get("fillPolicy", String.class);
        if (StringUtils.isBlank((String)fillPolicy)) {
            throw new ValidationErrorsException("Blob store group requires a fill policy configuration");
        }
        if (!this.fillPolicies.containsKey(fillPolicy)) {
            throw new ValidationErrorsException("Blob store group requires a valid fill policy name, options include [{}]", String.join((CharSequence)", ", this.fillPolicies.keySet()));
        }
        List memberNames = (List)config.attributes("group").get("members", List.class);
        this.validateNotEmptyOrSelfReferencing(name, memberNames);
        this.validateEligibleMembers(name, memberNames);
        this.validateOnlyEmptyOrNotWritableExistingMembersRemoved(name, memberNames);
    }

    private void validateEnabled() {
        if (!this.isEnabled()) {
            throw new ValidationErrorsException("Blob store groups are not enabled");
        }
    }

    private void validateNotEmptyOrSelfReferencing(String name, List<String> memberNames) {
        if (memberNames == null || memberNames.isEmpty()) {
            throw new ValidationErrorsException("Blob Store '" + name + "' cannot be empty");
        }
        if (memberNames.contains(name)) {
            throw new ValidationErrorsException("Blob Store '" + name + "' cannot contain itself");
        }
    }

    private void validateEligibleMembers(String name, List<String> memberNames) {
        for (String memberName : memberNames) {
            BlobStore member = this.blobStoreManager.get(memberName);
            if (!member.isGroupable()) {
                BlobStoreConfiguration memberConfig = member.getBlobStoreConfiguration();
                throw new ValidationErrorsException(String.format("Blob Store '%s' is of type '%s' and is not eligible to be a group member", memberName, memberConfig.getType()));
            }
            if (this.blobStoreManager.hasConflictingTasks(memberName)) {
                throw new ValidationErrorsException(String.format("Blob Store '%s' has conflicting tasks running and is not eligible to be a group member", memberName));
            }
            Predicate<String> sameGroup = name::equals;
            this.blobStoreManager.getParent(memberName).filter(sameGroup.negate()).ifPresent(groupName -> {
                throw new ValidationErrorsException(String.format("Blob Store '%s' is already a member of Blob Store Group '%s'", memberName, groupName));
            });
            int repoCount = this.blobStoreUtil.usageCount(memberName);
            if (repoCount <= 0) continue;
            throw new ValidationErrorsException(String.format("Blob Store '%s' is set as storage for %s repositories and is not eligible to be a group member", memberName, repoCount));
        }
    }

    private void validateOnlyEmptyOrNotWritableExistingMembersRemoved(String name, List<String> memberNames) {
        BlobStoreConfiguration currentConfiguration;
        BlobStore blobStore = this.blobStoreManager.get(name);
        if (blobStore != null && (currentConfiguration = blobStore.getBlobStoreConfiguration()) != null && currentConfiguration.getType().equals("Group")) {
            for (String existingMemberName : BlobStoreGroupConfigurationHelper.memberNames(currentConfiguration)) {
                BlobStore existingMember;
                if (memberNames.contains(existingMemberName) || !(existingMember = this.blobStoreManager.get(existingMemberName)).isWritable() && existingMember.isEmpty()) continue;
                throw new ValidationErrorsException(String.format("Blob Store '%s' cannot be removed from Blob Store Group '%s', use 'Admin - Remove a member from a blob store group' task instead", existingMemberName, name));
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return Optional.of(this.blobStoreGroupService).map(Provider::get).map(BlobStoreGroupService::isEnabled).orElse(false);
    }

    @Override
    public boolean configHasDependencyOn(BlobStoreConfiguration config, String blobStoreName) {
        return BlobStoreGroupConfigurationHelper.memberNames(config).contains(blobStoreName);
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Group")
        public String name();

        @MessageBundle.DefaultMessage(value="Members")
        public String membersLabel();

        @MessageBundle.DefaultMessage(value="Fill Policy")
        public String fillPolicyLabel();
    }
}

