/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.group;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.hash.HashCode;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.cache.Cache;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.CreatedExpiryPolicy;
import javax.cache.expiry.Duration;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.sonatype.goodies.common.Time;
import org.sonatype.nexus.blobstore.MemoryBlobSession;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobAttributes;
import org.sonatype.nexus.blobstore.api.BlobId;
import org.sonatype.nexus.blobstore.api.BlobSession;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.blobstore.api.BlobStoreException;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.blobstore.api.BlobStoreMetrics;
import org.sonatype.nexus.blobstore.api.BlobStoreUsageChecker;
import org.sonatype.nexus.blobstore.api.OperationMetrics;
import org.sonatype.nexus.blobstore.api.OperationType;
import org.sonatype.nexus.blobstore.api.RawObjectAccess;
import org.sonatype.nexus.blobstore.api.UnimplementedRawObjectAccess;
import org.sonatype.nexus.blobstore.api.metrics.BlobStoreMetricsService;
import org.sonatype.nexus.blobstore.group.BlobStoreGroupConfigurationHelper;
import org.sonatype.nexus.blobstore.group.FillPolicy;
import org.sonatype.nexus.blobstore.group.internal.BlobStoreGroupMetrics;
import org.sonatype.nexus.blobstore.metrics.MonitoringBlobStoreMetrics;
import org.sonatype.nexus.cache.CacheHelper;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.common.stateguard.Transitions;

@Named(value="Group")
public class BlobStoreGroup
extends StateGuardLifecycleSupport
implements BlobStore {
    private static final String RAW_OBJECTS_NOT_SUPPORTED = "Group BlobStore does not support raw objects";
    public static final String TYPE = "Group";
    public static final String CONFIG_KEY = "group";
    public static final String MEMBERS_KEY = "members";
    public static final String FILL_POLICY_KEY = "fillPolicy";
    public static final String FALLBACK_FILL_POLICY_TYPE = "writeToFirst";
    public static final String CACHE_NAME = "blobstore-group-blobIds";
    private final BlobStoreManager blobStoreManager;
    private final Map<String, Provider<FillPolicy>> fillPolicyProviders;
    private Provider<CacheHelper> cacheHelperProvider;
    private Time blobIdCacheTimeout;
    private Supplier<List<BlobStore>> members;
    private FillPolicy fillPolicy;
    private BlobStoreConfiguration blobStoreConfiguration;
    private Cache<BlobId, String> locatedBlobs;

    @Inject
    public BlobStoreGroup(BlobStoreManager blobStoreManager, Map<String, Provider<FillPolicy>> fillPolicyProviders, Provider<CacheHelper> cacheHelperProvider, @Named(value="${nexus.blobstore.group.blobId.cache.timeToLive:-2d}") @Named(value="${nexus.blobstore.group.blobId.cache.timeToLive:-2d}") Time blobIdCacheTimeout) {
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
        this.fillPolicyProviders = (Map)Preconditions.checkNotNull(fillPolicyProviders);
        this.cacheHelperProvider = (Provider)Preconditions.checkNotNull(cacheHelperProvider);
        this.blobIdCacheTimeout = (Time)Preconditions.checkNotNull((Object)blobIdCacheTimeout);
    }

    public void init(BlobStoreConfiguration configuration) {
        this.blobStoreConfiguration = configuration;
        this.members = Suppliers.memoize((Supplier)new MembersSupplier());
        String fillPolicyName = BlobStoreGroupConfigurationHelper.fillPolicyName(configuration);
        if (this.fillPolicyProviders.containsKey(fillPolicyName)) {
            this.fillPolicy = (FillPolicy)this.fillPolicyProviders.get(fillPolicyName).get();
        } else {
            this.log.warn("Unable to find fill policy {} for Blob Store Group {}, using fill policy {}", new Object[]{fillPolicyName, configuration.getName(), FALLBACK_FILL_POLICY_TYPE});
            this.fillPolicy = (FillPolicy)this.fillPolicyProviders.get(FALLBACK_FILL_POLICY_TYPE).get();
        }
    }

    protected void doStart() throws Exception {
        this.locatedBlobs = ((CacheHelper)this.cacheHelperProvider.get()).maybeCreateCache(CACHE_NAME, this.getCacheConfiguration());
    }

    private MutableConfiguration<BlobId, String> getCacheConfiguration() {
        return new MutableConfiguration().setStoreByValue(false).setExpiryPolicyFactory(CreatedExpiryPolicy.factoryOf((Duration)new Duration(this.blobIdCacheTimeout.unit(), this.blobIdCacheTimeout.value()))).setManagementEnabled(true).setStatisticsEnabled(true);
    }

    protected void doStop() throws Exception {
        this.locatedBlobs = null;
    }

    public BlobStoreConfiguration getBlobStoreConfiguration() {
        return this.blobStoreConfiguration;
    }

    @Guarded(by={"STARTED"})
    public BlobSession<?> openSession() {
        return new MemoryBlobSession(this);
    }

    @Guarded(by={"STARTED"})
    public Blob create(InputStream blobData, Map<String, String> headers) {
        return this.create(blobData, headers, null);
    }

    @Guarded(by={"STARTED"})
    @MonitoringBlobStoreMetrics(operationType=OperationType.UPLOAD)
    public Blob create(InputStream blobData, Map<String, String> headers, @Nullable BlobId blobId) {
        return this.create(headers, (BlobStore target) -> target.create(blobData, headers, blobId));
    }

    @Guarded(by={"STARTED"})
    @MonitoringBlobStoreMetrics(operationType=OperationType.UPLOAD)
    public Blob create(Path sourceFile, Map<String, String> headers, long size, HashCode sha1) {
        return this.create(headers, (BlobStore target) -> target.create(sourceFile, headers, size, sha1));
    }

    private Blob create(Map<String, String> headers, CreateBlobFunction createBlobFunction) {
        BlobStore result = this.fillPolicy.chooseBlobStore(this, headers);
        if (result == null) {
            throw new BlobStoreException("Unable to find a member Blob Store of '" + (Object)((Object)this) + "' for create", null);
        }
        Blob blob = createBlobFunction.create(result);
        this.locatedBlobs.put((Object)blob.getId(), (Object)result.getBlobStoreConfiguration().getName());
        return blob;
    }

    @Guarded(by={"STARTED"})
    public Blob copy(BlobId blobId, Map<String, String> headers) {
        BlobStore target = this.locate(blobId).orElseThrow(() -> new BlobStoreException("Unable to find blob", blobId));
        Blob blob = target.copy(blobId, headers);
        this.locatedBlobs.put((Object)blob.getId(), (Object)target.getBlobStoreConfiguration().getName());
        return blob;
    }

    @Nullable
    @Guarded(by={"STARTED"})
    @MonitoringBlobStoreMetrics(operationType=OperationType.DOWNLOAD)
    public Blob get(BlobId blobId) {
        return this.locate(blobId).map(target -> target.get(blobId)).orElse(null);
    }

    @Nullable
    @Guarded(by={"STARTED"})
    @MonitoringBlobStoreMetrics(operationType=OperationType.DOWNLOAD)
    public Blob get(BlobId blobId, boolean includeDeleted) {
        if (includeDeleted) {
            return ((List)this.members.get()).stream().filter(member -> member.exists(blobId)).map(member -> member.get(blobId, true)).filter(Objects::nonNull).findAny().orElse(null);
        }
        return this.locate(blobId).map(target -> target.get(blobId, false)).orElse(null);
    }

    @Guarded(by={"STARTED"})
    public boolean delete(BlobId blobId, String reason) {
        this.locatedBlobs.remove((Object)blobId);
        List locations = ((List)this.members.get()).stream().filter(member -> member.exists(blobId)).collect(Collectors.toList());
        if (!locations.isEmpty()) {
            return locations.stream().allMatch(member -> member.delete(blobId, reason));
        }
        return false;
    }

    @Guarded(by={"STARTED"})
    public boolean deleteHard(BlobId blobId) {
        this.locatedBlobs.remove((Object)blobId);
        List locations = ((List)this.members.get()).stream().filter(member -> member.exists(blobId)).collect(Collectors.toList());
        if (!locations.isEmpty()) {
            return locations.stream().allMatch(member -> member.deleteHard(blobId));
        }
        return false;
    }

    @Guarded(by={"STARTED"})
    public BlobStoreMetricsService getMetricsService() {
        throw new UnsupportedOperationException("metrics service is not available at a group level");
    }

    @Guarded(by={"STARTED"})
    public BlobStoreMetrics getMetrics() {
        Iterable<BlobStoreMetrics> membersMetrics = ((List)this.members.get()).stream().filter(BlobStore::isStarted).map(BlobStore::getMetrics)::iterator;
        return new BlobStoreGroupMetrics(membersMetrics);
    }

    public Map<OperationType, OperationMetrics> getOperationMetricsByType() {
        EnumMap<OperationType, OperationMetrics> result = new EnumMap<OperationType, OperationMetrics>(OperationType.class);
        Iterable metrics = ((List)this.members.get()).stream().map(BlobStore::getOperationMetricsByType)::iterator;
        for (Map metric : metrics) {
            for (Map.Entry metricsEntry : metric.entrySet()) {
                OperationType type = (OperationType)metricsEntry.getKey();
                OperationMetrics operationMetrics = (OperationMetrics)metricsEntry.getValue();
                OperationMetrics existingMetrics = (OperationMetrics)result.get(type);
                if (existingMetrics != null) {
                    OperationMetrics aggregatedMetrics = existingMetrics.add(operationMetrics);
                    result.put(type, aggregatedMetrics);
                    continue;
                }
                result.put(type, operationMetrics);
            }
        }
        return result;
    }

    public Map<OperationType, OperationMetrics> getOperationMetricsDelta() {
        EnumMap<OperationType, OperationMetrics> result = new EnumMap<OperationType, OperationMetrics>(OperationType.class);
        Iterable metrics = ((List)this.members.get()).stream().map(BlobStore::getOperationMetricsDelta)::iterator;
        for (Map metric : metrics) {
            for (Map.Entry metricsEntry : metric.entrySet()) {
                OperationType type = (OperationType)metricsEntry.getKey();
                OperationMetrics operationMetrics = (OperationMetrics)metricsEntry.getValue();
                OperationMetrics existingMetrics = (OperationMetrics)result.get(type);
                if (existingMetrics != null) {
                    OperationMetrics aggregatedMetrics = existingMetrics.add(operationMetrics);
                    result.put(type, aggregatedMetrics);
                    continue;
                }
                result.put(type, operationMetrics);
            }
        }
        return result;
    }

    public void clearOperationMetrics() {
    }

    @Guarded(by={"STARTED"})
    public synchronized void compact(@Nullable BlobStoreUsageChecker inUseChecker) {
        ((List)this.members.get()).stream().forEach(member -> member.compact(inUseChecker));
    }

    @Guarded(by={"STARTED"})
    public synchronized void deleteTempFiles(@Nullable Integer daysOlderThan) {
        ((List)this.members.get()).forEach(member -> this.deleteTempFiles(daysOlderThan));
    }

    public boolean undelete(@Nullable BlobStoreUsageChecker inUseChecker, BlobId blobId, BlobAttributes attributes, boolean isDryRun) {
        return ((List)this.members.get()).stream().map(member -> member.undelete(inUseChecker, blobId, attributes, isDryRun)).anyMatch(deleted -> deleted);
    }

    public boolean isStorageAvailable() {
        return true;
    }

    public boolean isGroupable() {
        return false;
    }

    public boolean isWritable() {
        return false;
    }

    public boolean isEmpty() {
        return ((List)this.members.get()).stream().map(BlobStore::isEmpty).reduce(true, Boolean::logicalAnd);
    }

    @Transitions(to="SHUTDOWN")
    public void shutdown() throws Exception {
        if (this.isStarted()) {
            this.doStop();
        }
    }

    public boolean exists(BlobId blobId) {
        return ((List)this.members.get()).stream().anyMatch(member -> member.exists(blobId));
    }

    @Guarded(by={"NEW", "STOPPED", "FAILED", "SHUTDOWN"})
    public void remove() {
    }

    public Stream<BlobId> getBlobIdStream() {
        return ((List)this.members.get()).stream().map(member -> member.getBlobIdStream()).flatMap(Function.identity());
    }

    public Stream<BlobId> getBlobIdUpdatedSinceStream(int sinceDays) {
        return ((List)this.members.get()).stream().flatMap(member -> member.getBlobIdUpdatedSinceStream(sinceDays));
    }

    public Stream<BlobId> getDirectPathBlobIdStream(String prefix) {
        return ((List)this.members.get()).stream().map(member -> member.getDirectPathBlobIdStream(prefix)).flatMap(Function.identity());
    }

    @Nullable
    public BlobAttributes getBlobAttributes(BlobId blobId) {
        return this.locate(blobId).map(target -> target.getBlobAttributes(blobId)).orElse(null);
    }

    public void setBlobAttributes(BlobId blobId, BlobAttributes blobAttributes) {
        this.locate(blobId).ifPresent(target -> target.setBlobAttributes(blobId, blobAttributes));
    }

    public List<BlobStore> getMembers() {
        return Collections.unmodifiableList((List)this.members.get());
    }

    public RawObjectAccess getRawObjectAccess() {
        return new UnimplementedRawObjectAccess();
    }

    @VisibleForTesting
    Optional<BlobStore> locate(BlobId blobId) {
        String blobStoreName = (String)this.locatedBlobs.get((Object)blobId);
        if (blobStoreName != null) {
            this.log.trace("{} location was cached as {}", (Object)blobId, (Object)blobStoreName);
            return Optional.ofNullable(this.blobStoreManager.get(blobStoreName));
        }
        BlobStore blobStore = this.search(blobId);
        if (blobStore != null && blobStore.isWritable()) {
            String memberName = blobStore.getBlobStoreConfiguration().getName();
            this.log.trace("Caching {} in member {}", (Object)blobId, (Object)memberName);
            this.locatedBlobs.put((Object)blobId, (Object)memberName);
        }
        return Optional.ofNullable(blobStore);
    }

    private BlobStore search(BlobId blobId) {
        this.log.trace("Searching for {} in {}", (Object)blobId, this.members);
        return ((List)this.members.get()).stream().sorted(Comparator.comparing(BlobStore::isWritable).reversed()).filter(member -> member.exists(blobId)).findAny().orElse(null);
    }

    public String toString() {
        String name = this.blobStoreConfiguration != null ? this.blobStoreConfiguration.getName() : null;
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "{" + "name='" + name + "'," + "members='" + this.members.get() + '\'' + '}';
    }

    @FunctionalInterface
    private static interface CreateBlobFunction {
        public Blob create(BlobStore var1);
    }

    private class MembersSupplier
    implements Supplier<List<BlobStore>> {
        private MembersSupplier() {
        }

        public List<BlobStore> get() {
            ArrayList<BlobStore> memberList = new ArrayList<BlobStore>();
            for (String name : BlobStoreGroupConfigurationHelper.memberNames(BlobStoreGroup.this.blobStoreConfiguration)) {
                BlobStore blobStore = BlobStoreGroup.this.blobStoreManager.get(name);
                if (blobStore == null) {
                    throw new BlobStoreException("Blob Store '" + name + "' not found", null);
                }
                memberList.add(blobStore);
            }
            return Collections.synchronizedList(memberList);
        }
    }
}

