/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore;

import java.io.InputStream;
import org.slf4j.Logger;
import org.sonatype.goodies.common.Loggers;
import org.sonatype.nexus.blobstore.PerformanceLoggingInputStream;
import org.sonatype.nexus.blobstore.api.Blob;

public class PerformanceLogger {
    private static final String IOSTAT_LOGGER_NAME = "org.sonatype.nexus.blobstore.iostat";
    private final Logger log = Loggers.getLogger((String)"org.sonatype.nexus.blobstore.iostat");
    private String blobStoreName = "<not set>";

    public void setBlobStoreName(String blobStoreName) {
        this.blobStoreName = blobStoreName;
    }

    public InputStream maybeWrapForPerformanceLogging(InputStream inputStream) {
        if (this.log.isDebugEnabled()) {
            return new PerformanceLoggingInputStream(inputStream, this);
        }
        return inputStream;
    }

    public void logRead(long bytes, long nanos) {
        if (!this.log.isDebugEnabled()) {
            return;
        }
        double millis = 0.0;
        double mbPerSecond = Double.NaN;
        if (nanos > 0L) {
            millis = (double)nanos / 1000000.0;
            mbPerSecond = (double)bytes / (double)nanos * 1000.0;
        }
        this.log.debug(String.format("blobstore %s: %d bytes read in %g ms (%g mb/s)", this.blobStoreName, bytes, millis, mbPerSecond));
    }

    public void logCreate(Blob blob, long nanos) {
        if (!this.log.isDebugEnabled()) {
            return;
        }
        long bytes = blob.getMetrics().getContentSize();
        double millis = 0.0;
        double mbPerSecond = Double.NaN;
        if (nanos > 0L) {
            millis = (double)nanos / 1000000.0;
            mbPerSecond = (double)bytes / (double)nanos * 1000.0;
        }
        this.log.debug(String.format("blobstore %s: %d bytes written in %g ms (%g mb/s)", this.blobStoreName, bytes, millis, mbPerSecond));
    }

    public void logDelete(long nanos) {
        if (!this.log.isDebugEnabled()) {
            return;
        }
        double millis = 0.0;
        if (nanos > 0L) {
            millis = (double)nanos / 1000000.0;
        }
        this.log.debug(String.format("blobstore %s: blob deleted in %g ms", this.blobStoreName, millis));
    }
}

