/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore;

import java.util.Map;
import java.util.UUID;
import javax.inject.Named;
import org.sonatype.nexus.blobstore.BlobIdLocationResolver;
import org.sonatype.nexus.blobstore.DirectPathLocationStrategy;
import org.sonatype.nexus.blobstore.LocationStrategy;
import org.sonatype.nexus.blobstore.TemporaryLocationStrategy;
import org.sonatype.nexus.blobstore.VolumeChapterLocationStrategy;
import org.sonatype.nexus.blobstore.api.BlobId;

@Named
public class DefaultBlobIdLocationResolver
implements BlobIdLocationResolver {
    public static final String TEMPORARY_BLOB_ID_PREFIX = "tmp$";
    public static final String DIRECT_PATH_BLOB_ID_PREFIX = "path$";
    protected final LocationStrategy permanentLocationStrategy = new VolumeChapterLocationStrategy();
    protected final LocationStrategy temporaryLocationStrategy = new TemporaryLocationStrategy();
    protected final LocationStrategy directLocationStrategy = new DirectPathLocationStrategy();

    @Override
    public String getLocation(BlobId id) {
        if (id.asUniqueString().startsWith(TEMPORARY_BLOB_ID_PREFIX)) {
            return this.temporaryLocationStrategy.location(id);
        }
        if (id.asUniqueString().startsWith(DIRECT_PATH_BLOB_ID_PREFIX)) {
            return this.directLocationStrategy.location(id);
        }
        return this.permanentLocationStrategy.location(id);
    }

    @Override
    public String getTemporaryLocation(BlobId id) {
        return this.temporaryLocationStrategy.location(id);
    }

    @Override
    public BlobId fromHeaders(Map<String, String> headers) {
        if (headers.containsKey("BlobStore.temporary-blob")) {
            return new BlobId(TEMPORARY_BLOB_ID_PREFIX + UUID.randomUUID().toString());
        }
        if (headers.containsKey("BlobStore.direct-path")) {
            return new BlobId(DIRECT_PATH_BLOB_ID_PREFIX + headers.get("BlobStore.blob-name"));
        }
        return new BlobId(UUID.randomUUID().toString());
    }
}

