/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.AccumulatingBlobStoreMetrics;
import org.sonatype.nexus.blobstore.api.BlobStoreMetrics;
import org.sonatype.nexus.blobstore.api.OperationMetrics;
import org.sonatype.nexus.blobstore.api.OperationType;
import org.sonatype.nexus.blobstore.api.metrics.BlobStoreMetricsPropertiesReader;
import org.sonatype.nexus.common.property.ImplicitSourcePropertiesFile;

public abstract class BlobStoreMetricsPropertiesReaderSupport<T extends ImplicitSourcePropertiesFile>
extends ComponentSupport
implements BlobStoreMetricsPropertiesReader {
    private T loadedProperties;

    protected abstract T getProperties() throws Exception;

    protected abstract Map<String, Long> getAvailableSpace() throws Exception;

    public BlobStoreMetrics readMetrics() throws Exception {
        T propertiesFile = this.loadProperties();
        if (propertiesFile == null) {
            return null;
        }
        long blobCount = Long.parseLong(propertiesFile.getProperty("blobCount", "0"));
        long totalSize = Long.parseLong(propertiesFile.getProperty("totalSize", "0"));
        return new AccumulatingBlobStoreMetrics(blobCount, totalSize, this.getAvailableSpace(), false);
    }

    public Map<OperationType, OperationMetrics> readOperationMetrics() throws Exception {
        T propertiesFile = this.loadProperties();
        if (propertiesFile == null) {
            this.log.warn("{} not found for blob store", (Object)this.metricsFilename());
            return Collections.emptyMap();
        }
        long downloadTotalErrorRequests = Long.parseLong(propertiesFile.getProperty("DOWNLOAD_totalErrorRequests", "0"));
        long downloadTotalSizeOnRequests = Long.parseLong(propertiesFile.getProperty("DOWNLOAD_totalSizeOnRequests", "0"));
        long downloadTotalSuccessfulRequests = Long.parseLong(propertiesFile.getProperty("DOWNLOAD_totalSuccessfulRequests", "0"));
        long downloadTotalTimeOnRequests = Long.parseLong(propertiesFile.getProperty("DOWNLOAD_totalTimeOnRequests", "0"));
        OperationMetrics downloadMetrics = new OperationMetrics();
        downloadMetrics.setBlobSize(downloadTotalSizeOnRequests);
        downloadMetrics.setErrorRequests(downloadTotalErrorRequests);
        downloadMetrics.setSuccessfulRequests(downloadTotalSuccessfulRequests);
        downloadMetrics.setTimeOnRequests(downloadTotalTimeOnRequests);
        long uploadTotalSuccessfulRequests = Long.parseLong(propertiesFile.getProperty("UPLOAD_totalSuccessfulRequests", "0"));
        long uploadTotalSizeOnRequests = Long.parseLong(propertiesFile.getProperty("UPLOAD_totalSizeOnRequests", "0"));
        long uploadTotalTimeOnRequests = Long.parseLong(propertiesFile.getProperty("UPLOAD_totalTimeOnRequests", "0"));
        long uploadTotalErrorRequests = Long.parseLong(propertiesFile.getProperty("UPLOAD_totalErrorRequests", "0"));
        OperationMetrics uploadMetrics = new OperationMetrics();
        uploadMetrics.setBlobSize(uploadTotalSizeOnRequests);
        uploadMetrics.setErrorRequests(uploadTotalErrorRequests);
        uploadMetrics.setSuccessfulRequests(uploadTotalSuccessfulRequests);
        uploadMetrics.setTimeOnRequests(uploadTotalTimeOnRequests);
        return ImmutableMap.of((Object)OperationType.DOWNLOAD, (Object)downloadMetrics, (Object)OperationType.UPLOAD, (Object)uploadMetrics);
    }

    private T loadProperties() throws Exception {
        if (this.loadedProperties != null) {
            return this.loadedProperties;
        }
        this.loadedProperties = this.getProperties();
        if (this.loadedProperties.exists()) {
            this.loadedProperties.load();
        }
        return this.loadedProperties;
    }
}

