/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore;

import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.BlobStoreDescriptor;
import org.sonatype.nexus.common.db.DatabaseCheck;

@Named
@Singleton
public class BlobStoreDescriptorProvider {
    private final Map<String, BlobStoreDescriptor> blobStoreDescriptors;
    private final DatabaseCheck databaseCheck;

    @Inject
    public BlobStoreDescriptorProvider(DatabaseCheck databaseCheck, Map<String, BlobStoreDescriptor> blobStoreDescriptors) {
        this.databaseCheck = databaseCheck;
        this.blobStoreDescriptors = blobStoreDescriptors;
    }

    public Map<String, BlobStoreDescriptor> get() {
        return this.blobStoreDescriptors.entrySet().stream().filter(item -> this.databaseCheck.isAllowedByVersion(((BlobStoreDescriptor)item.getValue()).getClass())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

